/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CrossValidationProvider;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MatrixValidationProvider
implements CrossValidationProvider {
    private final MatrixParameter trueParameter;
    private final MatrixParameter inferredParameter;
    private final int[] relevantDimensions;
    private final String[] colNames;
    private final String sumName;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        static final String PARSER_NAME = "matrixValidation";
        static final String TRUE_PARAMETER = "trueParameter";
        static final String INFERRED_PARAMETER = "inferredParameter";
        static final String LOG_SUM = "logSum";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(TRUE_PARAMETER);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject.getElementFirstChild(INFERRED_PARAMETER);
            String string = PARSER_NAME;
            if (xMLObject.hasId()) {
                string = xMLObject.getId();
            }
            if (matrixParameter.getRowDimension() != matrixParameter2.getRowDimension() || matrixParameter.getColumnDimension() != matrixParameter2.getColumnDimension()) {
                throw new XMLParseException("The matrix parameters contained in trueParameter and inferredParameter must have the same dimensions.");
            }
            MatrixValidationProvider matrixValidationProvider = new MatrixValidationProvider(matrixParameter, matrixParameter2, string);
            boolean bl = xMLObject.getAttribute(LOG_SUM, false);
            if (bl) {
                return new CrossValidationProvider.CrossValidatorSum(matrixValidationProvider, CrossValidationProvider.ValidationType.SQUARED_ERROR);
            }
            return new CrossValidationProvider.CrossValidator(matrixValidationProvider, CrossValidationProvider.ValidationType.SQUARED_ERROR);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newBooleanRule(LOG_SUM, true), new ElementRule(TRUE_PARAMETER, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(INFERRED_PARAMETER, new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return CrossValidationProvider.CrossValidator.class;
        }

        @Override
        public String getParserName() {
            return PARSER_NAME;
        }
    };

    MatrixValidationProvider(MatrixParameter matrixParameter, MatrixParameter matrixParameter2, String string) {
        int n;
        this.trueParameter = matrixParameter;
        this.inferredParameter = matrixParameter2;
        int n2 = matrixParameter.getDimension();
        this.relevantDimensions = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.relevantDimensions[n] = n;
        }
        this.colNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = n / matrixParameter.getRowDimension();
            int n4 = n - n3 * matrixParameter.getRowDimension();
            this.colNames[n] = string + (n3 + 1) + (n4 + 1);
        }
        this.sumName = string + ".TotalSum";
    }

    @Override
    public double[] getTrueValues() {
        return this.trueParameter.getParameterValues();
    }

    @Override
    public double[] getInferredValues() {
        return this.inferredParameter.getParameterValues();
    }

    @Override
    public int[] getRelevantDimensions() {
        return this.relevantDimensions;
    }

    @Override
    public String getName(int n) {
        return this.colNames[n];
    }

    @Override
    public String getNameSum(int n) {
        return this.sumName;
    }
}

