/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MatrixDiagonalLogger
extends Statistic.Abstract {
    private final MatrixParameterInterface matrix;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String MATRIX_DIAGONAL = "matrixDiagonals";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            if (matrixParameterInterface.getColumnDimension() != matrixParameterInterface.getRowDimension()) {
                throw new XMLParseException("Only square matrices can be converted to correlation matrices");
            }
            return new MatrixDiagonalLogger(matrixParameterInterface);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)};
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that is the diagonals of the associated matrix.";
        }

        @Override
        public Class getReturnType() {
            return MatrixDiagonalLogger.class;
        }

        @Override
        public String getParserName() {
            return MATRIX_DIAGONAL;
        }
    };

    public MatrixDiagonalLogger(MatrixParameterInterface matrixParameterInterface) {
        this.matrix = matrixParameterInterface;
    }

    @Override
    public int getDimension() {
        return this.matrix.getColumnDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        return this.matrix.getParameterValue(n, n);
    }

    @Override
    public String getDimensionName(int n) {
        return this.getStatisticName() + "." + this.matrix.getDimensionName(n);
    }
}

