/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.distributions;

import dr.geo.distributions.HyperSphereDistribution;
import dr.geo.math.Space;
import dr.math.LogTricks;

public class VonMisesFisherDistribution
extends HyperSphereDistribution {
    public VonMisesFisherDistribution(int n, Space space, double[] dArray, double d) {
        super(n, space, dArray, d);
    }

    @Override
    public double logPdf(double[] dArray) {
        return VonMisesFisherDistribution.logPdf(dArray, this.mean, this.kappa, this.space);
    }

    @Override
    public String getType() {
        return "von Mises-Fisher";
    }

    @Override
    protected int getAllowableDim() {
        return 3;
    }

    private static double logNormalizationConstant(double d) {
        if (d < 1.0E-10) {
            return -Math.log(2.0) - LOG_2_PI;
        }
        return Math.log(d) - LOG_2_PI - LogTricks.logDiff(d, -d);
    }

    public static double logPdf(double[] dArray, double[] dArray2, double d, Space space) {
        return VonMisesFisherDistribution.logNormalizationConstant(d) + d * HyperSphereDistribution.innerProduct(dArray, dArray2, space);
    }

    public static void main(String[] stringArray) {
        double d = 1.0;
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        System.err.println("logP = " + VonMisesFisherDistribution.logPdf(dArray2, dArray, d, Space.CARTESIAN) + " ?= -2.692464\n");
        double d2 = 1.0;
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 180.0};
        System.err.println("logP = " + VonMisesFisherDistribution.logPdf(dArray4, dArray3, d2, Space.LAT_LONG) + " ?= -3.692464\n");
        double d3 = 2.0;
        double[] dArray5 = new double[]{90.0, 0.0};
        double[] dArray6 = new double[]{0.0, 180.0};
        System.err.println("logP = " + VonMisesFisherDistribution.logPdf(dArray6, dArray5, d3, Space.LAT_LONG) + " ?= -3.126244");
    }
}

