/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.HypermutantAlignment;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class HypermutantAlignmentParser
extends AbstractXMLObjectParser {
    public static final String HYPERMUTANT_ALIGNMENT = "hypermutantAlignment";
    public static final String CONTEXT_TYPE = "type";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Alignment.class), new StringAttributeRule("type", "The type of APOBEC molecule being modelled", new String[]{HypermutantAlignment.APOBECType.ALL.toString(), HypermutantAlignment.APOBECType.BOTH.toString(), HypermutantAlignment.APOBECType.HA3G.toString(), HypermutantAlignment.APOBECType.HA3F.toString()}, false)};

    @Override
    public String getParserName() {
        return HYPERMUTANT_ALIGNMENT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        if (alignment.getDataType().getType() != 0) {
            throw new XMLParseException("HypermutantAlignment can only convert nucleotide alignments");
        }
        String string = xMLObject.getStringAttribute(CONTEXT_TYPE);
        HypermutantAlignment.APOBECType aPOBECType = null;
        try {
            aPOBECType = HypermutantAlignment.APOBECType.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XMLParseException("Unrecognised hypermutation type: " + string);
        }
        HypermutantAlignment hypermutantAlignment = new HypermutantAlignment(aPOBECType, alignment);
        int n = hypermutantAlignment.getMutatedContextCount();
        int n2 = n + hypermutantAlignment.getUnmutatedContextCount();
        Logger.getLogger("dr.evoxml").info("Converted alignment, '" + xMLObject.getId() + "' to a hypermutant alignment targeting " + aPOBECType.toString() + " contexts.\r\tPotentially mutated contexts: " + n + " out of a total of " + n2 + " contexts");
        return hypermutantAlignment;
    }

    @Override
    public String getParserDescription() {
        return "Converts an alignment so that 'A's at specific APOBEC targeted contexts are set to an A/G ambiguity code.";
    }

    @Override
    public Class getReturnType() {
        return Alignment.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

