/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evomodel.treedatalikelihood.preorder.ProcessSimulationDelegate;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;

public class ConditionalVarianceAndTransform {
    private final double[][] cholesky;
    private final Matrix affineTransform;
    private Matrix sBar;
    private final int[] missingIndices;
    private final int[] notMissingIndices;
    private final double[] tempStorage;
    private final int numMissing;
    private final int numNotMissing;
    private static final boolean DEBUG = false;

    public ConditionalVarianceAndTransform(Matrix matrix, int[] nArray, int[] nArray2) {
        this.missingIndices = nArray;
        this.notMissingIndices = nArray2;
        Matrix matrix2 = null;
        this.sBar = null;
        try {
            Matrix matrix3 = matrix.extractRowsAndColumns(nArray2, nArray2);
            Matrix matrix4 = matrix3.inverse();
            Matrix matrix5 = matrix.extractRowsAndColumns(nArray, nArray2);
            matrix2 = matrix5.product(matrix4);
            Matrix matrix6 = matrix2.productWithTransposed(matrix5);
            this.sBar = matrix.extractRowsAndColumns(nArray, nArray);
            this.sBar.decumulate(matrix6);
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.affineTransform = matrix2;
        this.cholesky = ProcessSimulationDelegate.AbstractContinuousTraitDelegate.getCholeskyOfVariance(this.sBar);
        this.tempStorage = new double[nArray.length];
        this.numMissing = nArray.length;
        this.numNotMissing = nArray2.length;
    }

    public double[] getConditionalMean(double[] dArray, int n, double[] dArray2, int n2) {
        int n3;
        double[] dArray3 = new double[this.numMissing];
        double[] dArray4 = new double[this.numNotMissing];
        for (n3 = 0; n3 < this.numNotMissing; ++n3) {
            int n4 = this.notMissingIndices[n3];
            dArray4[n3] = dArray[n + n4] - dArray2[n2 + n4];
        }
        for (n3 = 0; n3 < this.numMissing; ++n3) {
            double d = 0.0;
            for (int i = 0; i < this.numNotMissing; ++i) {
                d += this.affineTransform.component(n3, i) * dArray4[i];
            }
            dArray3[n3] = dArray2[n2 + this.missingIndices[n3]] + d;
        }
        return dArray3;
    }

    double[][] getConditionalCholesky() {
        return this.cholesky;
    }

    public Matrix getConditionalVariance() {
        return this.sBar;
    }

    double[] getTemporaryStorage() {
        return this.tempStorage;
    }
}

