/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.BranchDifferentialMassProvider;
import dr.evomodel.treedatalikelihood.discrete.BranchSubstitutionParameterDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;
import java.util.ArrayList;

public class HomogeneousSubstitutionParameterGradient
implements GradientWrtParameterProvider,
Reportable {
    private final Parameter parameter;
    private final TreeDataLikelihood treeDataLikelihood;
    private final TreeTrait treeTraitProvider;
    private final Tree tree;
    private final DifferentialMassProvider.Mode mode;
    private final double tolerance = 100.0;

    public HomogeneousSubstitutionParameterGradient(String string, TreeDataLikelihood treeDataLikelihood, Parameter parameter, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, int n, DifferentialMassProvider.Mode mode) {
        this.parameter = parameter;
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.mode = mode;
        String string2 = BranchSubstitutionParameterDelegate.getName(string);
        TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string2);
        if (treeTrait == null) {
            if (beagleDataLikelihoodDelegate.getBranchModel().getSubstitutionModels().size() != 1) {
                throw new RuntimeException("Homogeneous process should contain only one substitution model!");
            }
            DifferentiableSubstitutionModel differentiableSubstitutionModel = (DifferentiableSubstitutionModel)beagleDataLikelihoodDelegate.getBranchModel().getSubstitutionModels().get(0);
            DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter = differentiableSubstitutionModel.factory(parameter, n);
            DifferentialMassProvider.DifferentialWrapper differentialWrapper = new DifferentialMassProvider.DifferentialWrapper(differentiableSubstitutionModel, wrtParameter, mode);
            ArrayList<DifferentialMassProvider> arrayList = new ArrayList<DifferentialMassProvider>();
            arrayList.add(differentialWrapper);
            BranchDifferentialMassProvider branchDifferentialMassProvider = new BranchDifferentialMassProvider(null, arrayList);
            BranchSubstitutionParameterDelegate branchSubstitutionParameterDelegate = new BranchSubstitutionParameterDelegate(string, treeDataLikelihood.getTree(), beagleDataLikelihoodDelegate, treeDataLikelihood.getBranchRateModel(), branchDifferentialMassProvider);
            ProcessSimulation processSimulation = new ProcessSimulation(treeDataLikelihood, branchSubstitutionParameterDelegate);
            treeDataLikelihood.addTraits(processSimulation.getTreeTraits());
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string2);
        assert (this.treeTraitProvider != null);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity() {
        double d = 0.0;
        double[] dArray = (double[])this.treeTraitProvider.getTrait(this.tree, null);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return new double[]{d};
    }

    @Override
    public String getReport() {
        return this.mode.getReport() + " " + GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, 100.0);
    }
}

