/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.NewTipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipGradientViaFullConditionalDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class TreeTipGradient
implements GradientWrtParameterProvider,
Reportable {
    private final TreeDataLikelihood treeDataLikelihood;
    private final TreeTrait treeTraitProvider;
    private final Tree tree;
    private final Parameter traitParameter;
    private final int nTaxa;
    private final int nTraits;
    private final int dimTrait;
    private final Parameter maskParameter;
    private final int gradientOffset;
    private double tolerance = 0.001;

    public TreeTipGradient(String string, Parameter parameter, TreeDataLikelihood treeDataLikelihood, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, Parameter parameter2) {
        Object object;
        String string2;
        assert (treeDataLikelihood != null);
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.maskParameter = parameter2;
        String string3 = TipGradientViaFullConditionalDelegate.getName(string);
        String string4 = TipFullConditionalDistributionDelegate.getName(string);
        if (treeDataLikelihood.getTreeTrait(string4) == null) {
            continuousDataLikelihoodDelegate.addFullConditionalDensityTrait(string);
        }
        if (treeDataLikelihood.getTreeTrait(string2 = NewTipFullConditionalDistributionDelegate.getName(string)) == null) {
            continuousDataLikelihoodDelegate.addNewFullConditionalDensityTrait(string);
        }
        this.nTaxa = treeDataLikelihood.getTree().getExternalNodeCount();
        int n = 0;
        ContinuousTraitPartialsProvider continuousTraitPartialsProvider = continuousDataLikelihoodDelegate.getDataModel();
        if (parameter == null) {
            parameter = continuousTraitPartialsProvider.getParameter();
            if (continuousTraitPartialsProvider.getDataDimension() != continuousTraitPartialsProvider.getTraitDimension()) {
                throw new RuntimeException("Not currently implemented with unspecified parameter and dimension reduction.");
            }
        } else if (parameter != continuousTraitPartialsProvider.getParameter()) {
            object = continuousTraitPartialsProvider.getChildModels();
            for (int i = 0; i < ((ContinuousTraitPartialsProvider[])object).length && (continuousTraitPartialsProvider = object[i]).getParameter() != parameter; ++i) {
                n += continuousTraitPartialsProvider.getTraitDimension();
            }
        }
        if (parameter != continuousTraitPartialsProvider.getParameter()) {
            throw new RuntimeException("Supplied parameter does not match the parameter in the data model or any of its submodels.");
        }
        this.traitParameter = continuousTraitPartialsProvider.getParameter();
        this.dimTrait = continuousTraitPartialsProvider.getTraitDimension();
        this.nTraits = continuousTraitPartialsProvider.getTraitCount();
        this.gradientOffset = n;
        if (this.nTraits != 1) {
            throw new RuntimeException("Not yet implemented for >1 traits");
        }
        if (parameter2 != null && parameter2.getDimension() != this.traitParameter.getDimension()) {
            throw new RuntimeException("Trait and mask parameters must be the same size");
        }
        object = treeDataLikelihood.getTreeTrait(string3);
        if (object == null) {
            continuousDataLikelihoodDelegate.addFullConditionalGradientTrait(string, this.gradientOffset, this.dimTrait);
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string3);
        assert (this.treeTraitProvider != null);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.traitParameter;
    }

    @Override
    public int getDimension() {
        return this.getParameter().getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        int n;
        double[] dArray = new double[this.nTaxa * this.dimTrait * this.nTraits];
        int n2 = 0;
        for (n = 0; n < this.nTaxa; ++n) {
            double[] dArray2 = (double[])this.treeTraitProvider.getTrait(this.tree, this.tree.getExternalNode(n));
            System.arraycopy(dArray2, 0, dArray, n2, this.dimTrait);
            n2 += this.dimTrait;
        }
        if (this.maskParameter != null) {
            for (n = 0; n < this.maskParameter.getDimension(); ++n) {
                if (this.maskParameter.getParameterValue(n) != 0.0) continue;
                dArray[n] = 0.0;
            }
        }
        return dArray;
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, this.tolerance);
    }
}

