/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MicrosatelliteBitFlipOperator
extends SimpleMCMCOperator {
    private Parameter parameter;
    private Parameter dependencies;
    private int[] variableIndices;
    public static final int PRESENT = 1;
    public static final int ABSENT = 0;
    public static final int NO_DEPENDENCY = -1;
    public static final String MODEL_CHOOSE = "modelChoose";
    public static final String DEPENDENCIES = "dependencies";
    public static final String VARIABLE_INDICES = "variableIndices";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("modelChoose", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("dependencies", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("variableIndices", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true)};

        @Override
        public String getParserName() {
            return "msatModelSwitchOperator";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int[] nArray;
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(MicrosatelliteBitFlipOperator.MODEL_CHOOSE);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(MicrosatelliteBitFlipOperator.DEPENDENCIES);
            if (xMLObject.hasChildNamed(MicrosatelliteBitFlipOperator.VARIABLE_INDICES)) {
                double[] dArray = ((Parameter)xMLObject.getElementFirstChild(MicrosatelliteBitFlipOperator.VARIABLE_INDICES)).getParameterValues();
                nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    nArray[i] = (int)dArray[i];
                }
            } else {
                nArray = new int[]{0, 1, 2, 3, 4, 5};
            }
            return new MicrosatelliteBitFlipOperator(parameter, parameter2, d, nArray);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a microsatellite averaging operator on a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public MicrosatelliteBitFlipOperator(Parameter parameter, Parameter parameter2, double d, int[] nArray) {
        this.parameter = parameter;
        this.dependencies = parameter2;
        this.variableIndices = nArray;
        if (parameter.getDimension() != parameter2.getDimension()) {
            throw new RuntimeException("Dimenension of the parameter (" + parameter.getDimension() + ") does not equal to the dimension of the dependencies parameter(" + parameter2.getDimension() + ").");
        }
        this.setWeight(d);
    }

    @Override
    public String getOperatorName() {
        return "msatModelSwitch(" + this.parameter.getParameterName() + ")";
    }

    @Override
    public double doOperation() {
        int n;
        double d = 0.0;
        double[] dArray = new double[this.parameter.getDimension()];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = this.parameter.getParameterValue(n);
        }
        n = this.variableIndices[MathUtils.nextInt(this.variableIndices.length)];
        int n2 = (int)this.parameter.getParameterValue(n);
        int n3 = -1;
        if (n2 == 0) {
            n3 = 1;
        } else if (n2 == 1) {
            n3 = 0;
        } else {
            throw new RuntimeException("The parameter can only take values 0 or 1.");
        }
        dArray[n] = n3;
        for (int i = 0; i < dArray.length; ++i) {
            int n4 = (int)this.dependencies.getParameterValue(i);
            if (n4 <= -1 || dArray[n4] != 0.0 || dArray[i] != 1.0) continue;
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, n3);
        return d;
    }

    public final String getPerformanceSuggestion() {
        return "no suggestions available";
    }
}

