/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.periodpriors;

import dr.evomodel.epidemiology.casetocase.periodpriors.AbstractPeriodPriorDistribution;
import dr.inference.distribution.LogNormalDistributionModel;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.math.distributions.NormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IndividualPrior
extends AbstractPeriodPriorDistribution {
    ParametricDistributionModel distribution;
    public static final String INDIVIDUAL_PRIOR = "individualPrior";
    public static final String ID = "id";
    public static final String DISTRIBUTION = "distribution";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("id", false), new ElementRule("distribution", ParametricDistributionModel.class)};

        @Override
        public String getParserName() {
            return IndividualPrior.INDIVIDUAL_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = (String)xMLObject.getAttribute(IndividualPrior.ID);
            ParametricDistributionModel parametricDistributionModel = (ParametricDistributionModel)xMLObject.getElementFirstChild(IndividualPrior.DISTRIBUTION);
            return new IndividualPrior(string, parametricDistributionModel);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the probability of a set of doubles all being drawn from the specified prior distribution";
        }

        @Override
        public Class getReturnType() {
            return IndividualPrior.class;
        }
    };

    public IndividualPrior(String string, ParametricDistributionModel parametricDistributionModel) {
        super(string, false);
        this.distribution = parametricDistributionModel;
    }

    @Override
    public void reset() {
    }

    @Override
    public double calculateLogPosteriorProbability(double d, double d2) {
        double d3 = this.distribution.logPdf(d);
        double d4 = Math.log(1.0 - this.distribution.cdf(d2));
        if (d4 == Double.NEGATIVE_INFINITY) {
            if (this.distribution instanceof LogNormalDistributionModel) {
                double d5 = ((LogNormalDistributionModel)this.distribution).getMu();
                double d6 = ((LogNormalDistributionModel)this.distribution).getSigma();
                double d7 = (Math.log(d2) - d5) / d6;
                d4 = NormalDistribution.standardCDF(-d7, true);
            } else if (this.distribution instanceof NormalDistributionModel) {
                double d8 = ((NormalDistributionModel)this.distribution).getMean().getValue(0);
                double d9 = ((NormalDistributionModel)this.distribution).getStdev();
                double d10 = (d2 - d8) / d9;
                d4 = NormalDistribution.standardCDF(-d10, true);
            }
        }
        return d3 - d4;
    }

    @Override
    public double calculateLogPosteriorCDF(double d, boolean bl) {
        double d2 = bl ? Math.log(1.0 - this.distribution.cdf(d)) : Math.log(this.distribution.cdf(d));
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (this.distribution instanceof LogNormalDistributionModel) {
                double d3 = ((LogNormalDistributionModel)this.distribution).getMu();
                double d4 = ((LogNormalDistributionModel)this.distribution).getSigma();
                double d5 = (Math.log(d) - d3) / d4;
                d2 = NormalDistribution.standardCDF(-d5, true);
            } else if (this.distribution instanceof NormalDistributionModel) {
                double d6 = ((NormalDistributionModel)this.distribution).getMean().getValue(0);
                double d7 = ((NormalDistributionModel)this.distribution).getStdev();
                double d8 = (d - d6) / d7;
                d2 = NormalDistribution.standardCDF(-d8, true);
            }
        }
        return d2;
    }

    @Override
    public double calculateLogLikelihood(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += this.distribution.logPdf(d2);
        }
        return d;
    }
}

