/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TransmissionSubtreeSlideA
extends AbstractAdaptableTreeOperator {
    private CaseToCaseTreeLikelihood c2cLikelihood;
    private PartitionedTreeModel tree;
    private double size = 1.0;
    private boolean gaussian = false;
    private final boolean swapInRandomRate;
    private final boolean swapInRandomTrait;
    private final boolean resampleInfectionTimes;
    private AdaptationMode mode = AdaptationMode.DEFAULT;
    private static final boolean DEBUG = false;
    public static final String TRANSMISSION_SUBTREE_SLIDE_A = "transmissionSubtreeSlideA";
    public static final String SWAP_RATES = "swapInRandomRate";
    public static final String SWAP_TRAITS = "swapInRandomTrait";
    public static final String TARGET_ACCEPTANCE = "targetAcceptance";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("size", true), AttributeRule.newDoubleRule("targetAcceptance", true), AttributeRule.newBooleanRule("gaussian"), AttributeRule.newBooleanRule("swapInRandomRate", true), AttributeRule.newBooleanRule("swapInRandomTrait", true), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute(TransmissionSubtreeSlideA.SWAP_RATES, false);
            boolean bl2 = xMLObject.getAttribute(TransmissionSubtreeSlideA.SWAP_TRAITS, false);
            AdaptationMode adaptationMode = AdaptationMode.DEFAULT;
            if (xMLObject.hasAttribute("autoOptimize")) {
                adaptationMode = xMLObject.getBooleanAttribute("autoOptimize") ? AdaptationMode.ADAPTATION_ON : AdaptationMode.ADAPTATION_OFF;
            }
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getAttribute(TransmissionSubtreeSlideA.TARGET_ACCEPTANCE, 0.234);
            double d3 = xMLObject.getAttribute("size", 1.0);
            if (Double.isInfinite(d3) || d3 <= 0.0) {
                throw new XMLParseException("size attribute must be positive and not infinite. was " + d3 + " for tree " + caseToCaseTreeLikelihood.getTreeModel().getId());
            }
            boolean bl3 = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl3 = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            boolean bl4 = xMLObject.getBooleanAttribute("gaussian");
            TransmissionSubtreeSlideA transmissionSubtreeSlideA = new TransmissionSubtreeSlideA(caseToCaseTreeLikelihood, d, d3, bl4, bl, bl2, adaptationMode, bl3);
            return transmissionSubtreeSlideA;
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a phylogenetic subtree, preserving the transmission tree topology.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionSubtreeSlideA.class;
        }

        @Override
        public String getParserName() {
            return TransmissionSubtreeSlideA.TRANSMISSION_SUBTREE_SLIDE_A;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TransmissionSubtreeSlideA(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, double d2, boolean bl, boolean bl2, boolean bl3, AdaptationMode adaptationMode, boolean bl4) {
        super(adaptationMode);
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.tree = caseToCaseTreeLikelihood.getTreeModel();
        this.setWeight(d);
        if (d2 == 0.0) {
            double d3 = 0.0;
            for (int i = 0; i < this.tree.getNodeCount(); ++i) {
                d3 += this.tree.getBranchLength(this.tree.getNode(i));
            }
            d2 = d3 / (double)(2 * this.tree.getNodeCount());
        }
        this.size = d2;
        this.gaussian = bl;
        this.swapInRandomRate = bl2;
        this.swapInRandomTrait = bl3;
        this.resampleInfectionTimes = bl4;
        this.mode = adaptationMode;
    }

    @Override
    public double doOperation() {
        Serializable serializable;
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        double d = 0.0;
        ArrayList<NodeRef> arrayList = this.getEligibleNodes(this.tree, branchMapModel);
        NodeRef nodeRef = arrayList.get(MathUtils.nextInt(arrayList.size()));
        double d2 = arrayList.size();
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        NodeRef nodeRef3 = this.getOtherChild(this.tree, nodeRef2, nodeRef);
        NodeRef nodeRef4 = this.tree.getParent(nodeRef2);
        double d3 = this.getDelta();
        double d4 = this.tree.getNodeHeight(nodeRef2);
        double d5 = d4 + d3;
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        AbstractCase abstractCase2 = branchMapModel.get(nodeRef2.getNumber());
        AbstractCase abstractCase3 = branchMapModel.get(nodeRef3.getNumber());
        AbstractCase abstractCase4 = null;
        if (nodeRef4 != null) {
            abstractCase4 = branchMapModel.get(nodeRef4.getNumber());
        }
        if (this.resampleInfectionTimes) {
            if (abstractCase != abstractCase2) {
                abstractCase.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            if (abstractCase4 == null || abstractCase3 != abstractCase4) {
                abstractCase3.setInfectionBranchPosition(MathUtils.nextDouble());
            }
        }
        if (d3 > 0.0) {
            if (nodeRef4 != null && this.tree.getNodeHeight(nodeRef4) < d5) {
                serializable = nodeRef4;
                NodeRef nodeRef5 = nodeRef2;
                while (this.tree.getNodeHeight((NodeRef)serializable) < d5) {
                    nodeRef5 = serializable;
                    if ((serializable = this.tree.getParent((NodeRef)serializable)) != null) continue;
                }
                if (branchMapModel.get(nodeRef5.getNumber()) != branchMapModel.get(nodeRef2.getNumber())) {
                    return Double.NEGATIVE_INFINITY;
                }
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef5)) {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.addChild(nodeRef2, nodeRef5);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.setRoot(nodeRef2);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef5, nodeRef2);
                    }
                    if (this.tree.hasRates()) {
                        double d6 = this.tree.getNodeRate(nodeRef5);
                        this.tree.setNodeRate(nodeRef5, this.tree.getNodeRate(nodeRef2));
                        this.tree.setNodeRate(nodeRef2, d6);
                    }
                } else {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.removeChild((NodeRef)serializable, nodeRef5);
                    this.tree.addChild(nodeRef2, nodeRef5);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.addChild((NodeRef)serializable, nodeRef2);
                }
                this.tree.setNodeHeight(nodeRef2, d5);
                this.tree.endTreeEdit();
                int n = this.intersectingEdges(this.tree, nodeRef5, d4, branchMapModel, branchMapModel.get(nodeRef2.getNumber()), null);
                d -= Math.log(n);
            } else {
                this.tree.setNodeHeight(nodeRef2, d5);
                d += 0.0;
            }
        } else {
            if (this.tree.getNodeHeight(nodeRef) > d5) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.tree.getNodeHeight(nodeRef3) > d5) {
                AbstractCase abstractCase5;
                serializable = new ArrayList();
                int n = this.intersectingEdges(this.tree, nodeRef3, d5, branchMapModel, branchMapModel.get(nodeRef2.getNumber()), (List<NodeRef>)((Object)serializable));
                if (serializable.size() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n2 = MathUtils.nextInt(serializable.size());
                NodeRef nodeRef6 = (NodeRef)serializable.get(n2);
                NodeRef nodeRef7 = this.tree.getParent(nodeRef6);
                if (this.resampleInfectionTimes && (abstractCase5 = branchMapModel.get(nodeRef6.getNumber())) != abstractCase2) {
                    abstractCase5.setInfectionBranchPosition(MathUtils.nextDouble());
                }
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef2)) {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef7, nodeRef6);
                    this.tree.addChild(nodeRef2, nodeRef6);
                    this.tree.addChild(nodeRef7, nodeRef2);
                    this.tree.setRoot(nodeRef3);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef2, nodeRef3);
                    }
                    if (this.tree.hasRates()) {
                        double d7 = this.tree.getNodeRate(nodeRef2);
                        this.tree.setNodeRate(nodeRef2, this.tree.getNodeRate(nodeRef3));
                        this.tree.setNodeRate(nodeRef3, d7);
                    }
                } else {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.removeChild(nodeRef7, nodeRef6);
                    this.tree.addChild(nodeRef2, nodeRef6);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.addChild(nodeRef7, nodeRef2);
                }
                this.tree.setNodeHeight(nodeRef2, d5);
                this.tree.endTreeEdit();
                d += Math.log(n);
            } else {
                this.tree.setNodeHeight(nodeRef2, d5);
                d += 0.0;
            }
        }
        if (this.swapInRandomRate && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            double d8 = this.tree.getNodeRate(nodeRef);
            this.tree.setNodeRate(nodeRef, this.tree.getNodeRate((NodeRef)serializable));
            this.tree.setNodeRate((NodeRef)serializable, d8);
        }
        if (this.swapInRandomTrait && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            this.tree.swapAllTraits(nodeRef, (NodeRef)serializable);
        }
        if (!Double.isInfinite(d)) {
            double d9 = this.getEligibleNodes(this.tree, branchMapModel).size();
            d += Math.log(d2 / d9);
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private boolean eligibleForMove(NodeRef nodeRef, TreeModel treeModel, BranchMapModel branchMapModel) {
        return !treeModel.isRoot(nodeRef) && (treeModel.getParent(treeModel.getParent(nodeRef)) != null && branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) == branchMapModel.get(treeModel.getParent(treeModel.getParent(nodeRef)).getNumber()) || branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) == branchMapModel.get(this.getOtherChild(treeModel, treeModel.getParent(nodeRef), nodeRef).getNumber()));
    }

    private ArrayList<NodeRef> getEligibleNodes(TreeModel treeModel, BranchMapModel branchMapModel) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (NodeRef nodeRef : treeModel.getNodes()) {
            if (!this.eligibleForMove(nodeRef, treeModel, branchMapModel)) continue;
            arrayList.add(nodeRef);
        }
        return arrayList;
    }

    private int intersectingEdges(Tree tree, NodeRef nodeRef, double d, BranchMapModel branchMapModel, AbstractCase abstractCase, List<NodeRef> list) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.getNodeHeight(nodeRef2) < d || branchMapModel.get(nodeRef2.getNumber()) != abstractCase) {
            return 0;
        }
        if (tree.getNodeHeight(nodeRef) < d) {
            if (list != null) {
                list.add(nodeRef);
            }
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += this.intersectingEdges(tree, tree.getChild(nodeRef, i), d, branchMapModel, abstractCase, list);
        }
        return n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return "transmissionSubtreeSlideA (" + this.tree.getId() + ")";
    }
}

