/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeLogger;
import dr.evomodelxml.tree.TreeLoggerParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PartitionedTreeLoggerParser
extends TreeLoggerParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[super.getSyntaxRules().length + 1];

    public PartitionedTreeLoggerParser() {
        System.arraycopy(super.getSyntaxRules(), 0, this.rules, 0, this.rules.length - 1);
        this.rules[this.rules.length - 1] = new ElementRule(CaseToCaseTreeLikelihood.class);
    }

    public String getParserName() {
        return "logPartitionedTree";
    }

    public String getParserDescription() {
        return "Logs a partitioned tree (phylogenetic tree and transmission tree)";
    }

    public Class getReturnType() {
        return PartitionedTreeLogger.class;
    }

    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        this.parseXMLParameters(xMLObject);
        CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
        PartitionedTreeLogger partitionedTreeLogger = new PartitionedTreeLogger(caseToCaseTreeLikelihood, this.tree, this.branchRates, this.treeAttributeProviders, this.treeTraitProviders, this.formatter, this.logEvery, this.nexusFormat, this.sortTranslationTable, this.mapNames, this.format, this.condition);
        if (this.title != null) {
            partitionedTreeLogger.setTitle(this.title);
        }
        return partitionedTreeLogger;
    }
}

