/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.epidemiology.LogisticGrowthN0;
import dr.evomodel.epidemiology.LogisticGrowthN0ModelParser;
import dr.inference.model.Parameter;

public class LogisticGrowthN0Model
extends DemographicModel {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter t50Parameter = null;
    LogisticGrowthN0 logisticGrowthN0 = null;
    boolean usingGrowthRate = true;

    public LogisticGrowthN0Model(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        this(LogisticGrowthN0ModelParser.LOGISTIC_GROWTH_MODEL, parameter, parameter2, parameter3, type, bl);
    }

    public LogisticGrowthN0Model(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        super(string);
        this.logisticGrowthN0 = new LogisticGrowthN0(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.t50Parameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.usingGrowthRate = bl;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.logisticGrowthN0.setN0(this.N0Parameter.getParameterValue(0));
        if (this.usingGrowthRate) {
            double d = this.growthRateParameter.getParameterValue(0);
            this.logisticGrowthN0.setGrowthRate(d);
        } else {
            double d = this.growthRateParameter.getParameterValue(0);
            this.logisticGrowthN0.setDoublingTime(d);
        }
        this.logisticGrowthN0.setT50(this.t50Parameter.getParameterValue(0));
        return this.logisticGrowthN0;
    }
}

