/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.math.SparseMatrixExponential;
import dr.math.matrixAlgebra.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TopographicalMap {
    public static final String FORMAT = "%3.2f";
    private double xStart;
    private double xEnd;
    private double yStart;
    private double yEnd;
    private double xDelta;
    private double yDelta;
    public static final String defaultInvalidString = "*";
    public static final String TERRAIN = "terrain";
    public static final String TYPE_TYPE = "tileTypes";
    public static final String TYPE = "type";
    private double[][] map;
    private int[] indexByXY;
    private int[] xyByIndex;
    SparseMatrixExponential matrixExp;
    private int xDim;
    private int yDim;
    private int order;
    private int nonZeroElements;
    public static double[][] sillyMap = new double[][]{{0.0, 100.0, 0.0, 100.0, 0.0}, {0.0, 0.0, 0.0, 100.0, 0.0}, {100.0, 0.0, 100.0, 100.0, 0.0}, {100.0, 0.0, 100.0, 100.0, 0.0}, {100.0, 0.0, 0.0, 0.0, 0.0}};

    public TopographicalMap(double d, double d2, double d3, double d4, int n, int n2) {
        this.xStart = d;
        this.xEnd = d2;
        this.yStart = d3;
        this.yEnd = d4;
        this.xDim = n;
        this.yDim = n2;
        this.map = new double[n][n2];
        this.xDelta = (d2 - d) / (double)n;
        this.yDelta = (d4 - d3) / (double)n2;
    }

    public TopographicalMap(double[][] dArray) {
        this.xDim = dArray.length;
        this.yDim = dArray[0].length;
        this.map = dArray;
        this.order = this.setUpIndices();
        this.setUpRandomWalkMatrix();
    }

    public int getXDim() {
        return this.xDim;
    }

    public int getYDim() {
        return this.yDim;
    }

    public int getOrder() {
        return this.order;
    }

    public int getNonZeroSize() {
        return this.nonZeroElements;
    }

    private int setUpIndices() {
        int n = 0;
        this.indexByXY = new int[this.xDim * this.yDim];
        int[] nArray = new int[this.xDim * this.yDim];
        for (int i = 0; i < this.xDim; ++i) {
            for (int j = 0; j < this.yDim; ++j) {
                int n2 = i * this.yDim + j;
                if (!Double.isNaN(this.map[i][j])) {
                    nArray[n] = n2;
                    this.indexByXY[n2] = n++;
                    continue;
                }
                this.indexByXY[n2] = -1;
            }
        }
        this.xyByIndex = new int[n];
        this.xyByIndex = nArray;
        return n;
    }

    public double getCTMCProbability(double[] dArray, double[] dArray2, double d) {
        int n = this.getIndex((int)dArray[0], (int)dArray[1]);
        int n2 = this.getIndex((int)dArray2[0], (int)dArray2[1]);
        if (n == -1 || n2 == -1) {
            return 0.0;
        }
        double d2 = this.matrixExp.getExponentialEntry(n, n2, d);
        return d2;
    }

    public SparseMatrixExponential getMatrix() {
        return this.matrixExp;
    }

    public boolean isValidPoint(int n, int n2) {
        return this.getIndex(n, n2) != -1;
    }

    public int getIndex(int n, int n2) {
        if (n < 0 || n >= this.xDim || n2 < 0 || n2 >= this.yDim) {
            return -1;
        }
        return this.indexByXY[n * this.yDim + n2];
    }

    public int getX(int n) {
        return this.xyByIndex[n] / this.yDim;
    }

    public int getY(int n) {
        int n2 = this.xyByIndex[n];
        int n3 = this.yDim;
        int n4 = n2 % n3;
        return n4;
    }

    private void setUpRandomWalkMatrix() {
        int n;
        ArrayList<GraphEdge> arrayList = new ArrayList<GraphEdge>();
        for (int i = 0; i < this.order; ++i) {
            int n2;
            int n3 = this.getX(i);
            n = this.getIndex(n3 - 1, (n2 = this.getY(i)) - 1);
            if (n != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 - 1, n2 - 1)));
            }
            if ((n = this.getIndex(n3 - 1, n2)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 - 1, n2)));
            }
            if ((n = this.getIndex(n3 - 1, n2 + 1)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 - 1, n2 + 1)));
            }
            if ((n = this.getIndex(n3, n2 - 1)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3, n2 - 1)));
            }
            if ((n = this.getIndex(n3, n2 + 1)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3, n2 + 1)));
            }
            if ((n = this.getIndex(n3 + 1, n2 - 1)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 + 1, n2 - 1)));
            }
            if ((n = this.getIndex(n3 + 1, n2)) != -1) {
                arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 + 1, n2)));
            }
            if ((n = this.getIndex(n3 + 1, n2 + 1)) == -1) continue;
            arrayList.add(new GraphEdge(i, n, this.getWeight(n3, n2, n3 + 1, n2 + 1)));
        }
        double[] dArray = new double[this.order];
        this.nonZeroElements = arrayList.size() + this.order;
        this.matrixExp = new SparseMatrixExponential(this.order, this.nonZeroElements);
        for (GraphEdge graphEdge : arrayList) {
            n = graphEdge.getStart();
            int n4 = graphEdge.getStop();
            double d = graphEdge.getWeight();
            int n5 = n;
            dArray[n5] = dArray[n5] - d;
            this.matrixExp.addEntry(n, n4, d);
        }
        double d = 0.0;
        for (n = 0; n < this.order; ++n) {
            if (-2.0 * dArray[n] > d) {
                d = -2.0 * dArray[n];
            }
            this.matrixExp.addEntry(n, n, dArray[n]);
        }
        this.matrixExp.setNorm(d);
    }

    public void doStuff() {
        System.err.println(this.matrixExp.getExponentialEntry(0, 1, 1000.0));
        System.err.println(this.matrixExp.getExponentialEntry(0, 0, 1000.0));
    }

    public static void writeEigenvectors(String string, double[][] dArray) throws IOException {
        PrintWriter printWriter = string.endsWith("gz") ? new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(string)))) : new PrintWriter(new FileWriter(string));
        int n = dArray.length;
        printWriter.println(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                printWriter.println(dArray[i][j]);
            }
        }
        printWriter.close();
    }

    public static void writeEigenvalues(String string, double[] dArray) throws IOException {
        PrintWriter printWriter = string.endsWith("gz") ? new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(string)))) : new PrintWriter(new FileWriter(string));
        printWriter.println(dArray.length);
        for (double d : dArray) {
            printWriter.println(d);
        }
        printWriter.close();
    }

    public static int extractInt(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    public static double[][] readGRASSAscii(String string) throws IOException {
        return TopographicalMap.readGRASSAscii(string, defaultInvalidString);
    }

    public static double[][] readGRASSAscii(String string, String string2) throws IOException {
        BufferedReader bufferedReader = TopographicalMap.getReader(string);
        String string3 = bufferedReader.readLine();
        String string4 = bufferedReader.readLine();
        String string5 = bufferedReader.readLine();
        String string6 = bufferedReader.readLine();
        int n = TopographicalMap.extractInt(bufferedReader.readLine());
        int n2 = TopographicalMap.extractInt(bufferedReader.readLine());
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            String string7 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string7);
            for (int j = 0; j < n2; ++j) {
                String string8 = stringTokenizer.nextToken();
                dArray[i][j] = string8.compareTo(string2) == 0 ? Double.NaN : Double.parseDouble(string8);
            }
        }
        return dArray;
    }

    public String toString() {
        return this.toCartogram();
    }

    public String toCartogram() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.xDim; ++i) {
            for (int j = 0; j < this.yDim; ++j) {
                stringBuffer.append(String.format(FORMAT, this.map[i][j]));
                if (j >= this.yDim - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static BufferedReader getReader(String string) throws IOException {
        BufferedReader bufferedReader = string.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new FileReader(string));
        return bufferedReader;
    }

    public static BufferedWriter getWriter(String string) throws IOException {
        BufferedWriter bufferedWriter = string.endsWith("gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(string)))) : new BufferedWriter(new FileWriter(string));
        return bufferedWriter;
    }

    public static double[] readEigenvalues(String string) throws IOException {
        BufferedReader bufferedReader = TopographicalMap.getReader(string);
        int n = Integer.parseInt(bufferedReader.readLine());
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(bufferedReader.readLine());
        }
        bufferedReader.close();
        return dArray;
    }

    public static double[][] readEigenvectors(String string) throws IOException {
        BufferedReader bufferedReader = TopographicalMap.getReader(string);
        int n = Integer.parseInt(bufferedReader.readLine());
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = Double.parseDouble(bufferedReader.readLine());
            }
        }
        bufferedReader.close();
        return dArray;
    }

    public static String mapToXMLString(double[][] dArray, int n) {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        return xMLOutputter.outputString(TopographicalMap.mapToXML(dArray, n));
    }

    public static Element mapToXML(double[][] dArray, int n) {
        Element element;
        int n2;
        Element element2 = new Element(TERRAIN);
        Element element3 = new Element(TYPE_TYPE);
        Element element4 = new Element("size");
        Element element5 = new Element("content");
        element2.addContent(element3);
        element2.addContent(element4);
        element2.addContent(element5);
        element4.addContent(new Element("rows").addContent(Integer.toString(dArray.length)));
        element4.addContent(new Element("columns").addContent(Integer.toString(dArray[0].length)));
        element4.addContent(new Element("height").addContent(Integer.toString(dArray.length)));
        element4.addContent(new Element("width").addContent(Integer.toString(dArray[0].length)));
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                if (Double.isNaN(dArray[i][j])) continue;
                if (dArray[i][j] < d) {
                    d = dArray[i][j];
                }
                if (!(dArray[i][j] > d2)) continue;
                d2 = dArray[i][j];
            }
        }
        double[] dArray2 = new double[n];
        double d3 = d2 - d;
        double d4 = d3 / (double)n;
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = d + d4 * (double)(n2 + 1);
        }
        n2 = 255 / n;
        double d5 = d + d4 / 2.0;
        int n3 = 255 - n2;
        for (int i = 0; i < n; ++i) {
            element = new Element(TYPE);
            element.addContent(new Element("name").addContent("L" + Integer.toString(i)));
            element.addContent(new Element("cost").addContent(Integer.toString((int)d5)));
            Element element6 = new Element("color");
            element6.setAttribute("r", Integer.toString(n3));
            element6.setAttribute("g", Integer.toString(n3));
            element6.setAttribute("b", Integer.toString(n3));
            element.addContent(element6);
            element3.addContent(element);
            d5 += d4;
            n3 -= n2;
        }
        Element element7 = new Element(TYPE);
        element7.addContent(new Element("name").addContent("B"));
        element7.addContent(new Element("blocked"));
        element = new Element("color");
        element.setAttribute("r", Integer.toString(255));
        element.setAttribute("g", Integer.toString(255));
        element.setAttribute("b", Integer.toString(255));
        element7.addContent(element);
        element3.addContent(element7);
        int n4 = 0;
        element5.addContent(new Element("default").addContent("B"));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                if (!Double.isNaN(dArray[i][j])) {
                    ++n4;
                    double d6 = dArray[i][j];
                    int n5 = 0;
                    try {
                        while (d6 > dArray2[n5]) {
                            ++n5;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Error: " + exception);
                        System.err.println("value = " + d6);
                        System.err.println("cuts = " + new Vector(dArray2));
                        System.err.println("min = " + d);
                        System.err.println("max = " + d2);
                        System.exit(-1);
                    }
                    Element element8 = new Element("column");
                    element8.setAttribute("r", Integer.toString(i));
                    element8.setAttribute("c", Integer.toString(j));
                    element8.setAttribute("length", "1");
                    element8.addContent("L" + Integer.toString(n5));
                    element5.addContent(element8);
                    stringBuffer.append(n5 + 1 + " ");
                    continue;
                }
                stringBuffer.append("NA ");
            }
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer);
        return element2;
    }

    public static void writeXML(String string) throws IOException {
    }

    public double getWeight(int n, int n2, int n3, int n4) {
        return 1.0 / (100.0 * Math.abs(this.map[n][n2] - this.map[n3][n4]) + 1.0);
    }

    public static void main(String[] stringArray) {
        double[][] dArray = null;
        try {
            dArray = TopographicalMap.readGRASSAscii(stringArray[1]);
            System.err.println("Read in GRASS file.");
            System.err.println("Writing XML file.");
            String string = TopographicalMap.mapToXMLString(dArray, Integer.parseInt(stringArray[0]));
            PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[2]));
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Command-line error.");
            System.err.println("USAGE: program_name <# of levels> <GRASS file> <XML file>");
        }
    }

    public class GraphEdge {
        private int start;
        private int stop;
        private double weight;

        public GraphEdge(int n, int n2, double d) {
            this.start = n;
            this.stop = n2;
            this.weight = d;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getStop() {
            return this.stop;
        }

        public void setStop(int n) {
            this.stop = n;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double d) {
            this.weight = d;
        }
    }
}

