/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeAttributeProvider;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.treedatalikelihood.hmc.AbstractPrecisionGradient;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundEigenMatrix;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.ops.EigenOps;

public class MultivariateElasticModel
extends AbstractModel
implements TreeAttributeProvider {
    private static final String ELASTIC_PROCESS = "multivariateElasticModel";
    private static final String ELASTIC_TREE_ATTRIBUTE = "strengthOfSelection";
    public static final double LOG2PI = Math.log(Math.PI * 2);
    private MatrixParameterInterface strengthOfSelectionMatrixParameter;
    private EigenDecomposition eigenDecompositionStrengthOfSelection = null;
    private EigenDecomposition savedEigenDecompositionStrengthOfSelection = null;
    private Parametrization parametrization;
    private boolean isSymmetric;
    private int dim;
    private boolean variableChanged = true;
    private boolean storedVariableChanged;

    public MultivariateElasticModel(MatrixParameterInterface matrixParameterInterface) {
        super(ELASTIC_PROCESS);
        this.strengthOfSelectionMatrixParameter = matrixParameterInterface;
        this.dim = matrixParameterInterface.getRowDimension();
        assert (this.dim == matrixParameterInterface.getColumnDimension()) : "Strength of Selection matrix should be square.";
        this.parametrization = matrixParameterInterface instanceof DiagonalMatrix ? Parametrization.AS_DIAGONAL : (matrixParameterInterface instanceof CompoundEigenMatrix ? Parametrization.AS_DECOMPOSED : Parametrization.GENERAL);
        this.isSymmetric = matrixParameterInterface.isConstrainedSymmetric();
        this.calculateSelectionInfo();
        this.addVariable(matrixParameterInterface);
    }

    public MultivariateElasticModel() {
        super(ELASTIC_PROCESS);
    }

    private void calculateSelectionInfo() {
        this.eigenDecompositionStrengthOfSelection = this.parametrization.decomposeStrenghtOfSelection(this.strengthOfSelectionMatrixParameter, this.dim, this.isSymmetric);
    }

    public MatrixParameterInterface getStrengthOfSelectionMatrixParameter() {
        this.checkVariableChanged();
        return this.strengthOfSelectionMatrixParameter;
    }

    public double[][] getStrengthOfSelectionMatrix() {
        if (this.strengthOfSelectionMatrixParameter != null) {
            this.checkVariableChanged();
            return this.strengthOfSelectionMatrixParameter.getParameterAsMatrix();
        }
        return null;
    }

    public double[] getStrengthOfSelectionMatrixAsVector() {
        return AbstractPrecisionGradient.flatten(this.getStrengthOfSelectionMatrix());
    }

    public double[] getEigenValuesStrengthOfSelection() {
        if (this.strengthOfSelectionMatrixParameter != null) {
            this.checkVariableChanged();
            return this.eigenDecompositionStrengthOfSelection.getEigenValues();
        }
        return null;
    }

    public double[] getEigenVectorsStrengthOfSelection() {
        if (this.strengthOfSelectionMatrixParameter != null) {
            this.checkVariableChanged();
            return this.eigenDecompositionStrengthOfSelection.getEigenVectors();
        }
        return null;
    }

    private void checkVariableChanged() {
        if (this.variableChanged) {
            this.calculateSelectionInfo();
            this.variableChanged = false;
        }
    }

    public boolean isDiagonal() {
        return this.parametrization == Parametrization.AS_DIAGONAL;
    }

    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    private static double[] identityVector(int n) {
        double[] dArray = new double[n * n];
        for (int i = 0; i < n; ++i) {
            dArray[i * n + i] = 1.0;
        }
        return dArray;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.variableChanged = true;
    }

    @Override
    protected void storeState() {
        this.savedEigenDecompositionStrengthOfSelection = this.eigenDecompositionStrengthOfSelection;
        this.storedVariableChanged = this.variableChanged;
    }

    @Override
    protected void restoreState() {
        this.eigenDecompositionStrengthOfSelection = this.savedEigenDecompositionStrengthOfSelection;
        this.variableChanged = this.storedVariableChanged;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String[] getTreeAttributeLabel() {
        return new String[]{ELASTIC_TREE_ATTRIBUTE};
    }

    @Override
    public String[] getAttributeForTree(Tree tree) {
        if (this.strengthOfSelectionMatrixParameter != null) {
            return new String[]{this.strengthOfSelectionMatrixParameter.toString()};
        }
        this.strengthOfSelectionMatrixParameter.toString();
        return new String[]{"null"};
    }

    static enum Parametrization {
        AS_DIAGONAL{

            @Override
            public EigenDecomposition decomposeStrenghtOfSelection(MatrixParameterInterface matrixParameterInterface, int n, boolean bl) {
                return new EigenDecomposition(MultivariateElasticModel.identityVector(n), null, ((DiagonalMatrix)matrixParameterInterface).getDiagonalParameter().getParameterValues());
            }
        }
        ,
        AS_DECOMPOSED{

            @Override
            public EigenDecomposition decomposeStrenghtOfSelection(MatrixParameterInterface matrixParameterInterface, int n, boolean bl) {
                return new EigenDecomposition(((CompoundEigenMatrix)matrixParameterInterface).getEigenVectors(), null, ((CompoundEigenMatrix)matrixParameterInterface).getEigenValues());
            }
        }
        ,
        GENERAL{

            @Override
            public EigenDecomposition decomposeStrenghtOfSelection(MatrixParameterInterface matrixParameterInterface, int n, boolean bl) {
                DenseMatrix64F denseMatrix64F = MissingOps.wrap(matrixParameterInterface);
                org.ejml.interfaces.decomposition.EigenDecomposition<DenseMatrix64F> eigenDecomposition = DecompositionFactory.eig(n, true, bl);
                if (!eigenDecomposition.decompose(denseMatrix64F)) {
                    throw new RuntimeException("Eigen decomposition failed.");
                }
                return new EigenDecomposition(this.eigenVectorsMatrix(eigenDecomposition), null, this.eigenValuesMatrix(eigenDecomposition, n));
            }

            private double[] eigenValuesMatrix(org.ejml.interfaces.decomposition.EigenDecomposition eigenDecomposition, int n) {
                assert (eigenDecomposition != null) : "The eigen decomposition should already be computed at this point.";
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    Complex64F complex64F = eigenDecomposition.getEigenvalue(i);
                    assert (complex64F.isReal()) : "Selection strength A should only have real eigenvalues.";
                    assert (complex64F.real > 0.0) : "Selection strength A should only have positive real eigenvalues.";
                    dArray[i] = complex64F.real;
                }
                return dArray;
            }

            private double[] eigenVectorsMatrix(org.ejml.interfaces.decomposition.EigenDecomposition eigenDecomposition) {
                assert (eigenDecomposition != null) : "The eigen decomposition should already be computed at this point.";
                return EigenOps.createMatrixV(eigenDecomposition).getData();
            }
        };


        abstract EigenDecomposition decomposeStrenghtOfSelection(MatrixParameterInterface var1, int var2, boolean var3);
    }
}

