/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.geo.cartogram.CartogramMapping;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.logging.Logger;

public class CartogramDiffusionModel
extends MultivariateDiffusionModel {
    public static final String DIFFUSION_PROCESS = "cartogramDiffusionModel";
    public static final String FILENAME = "cartogramFileName";
    public static final String DENSITY = "density";
    public static final String BOUNDING_BOX = "boundingBox";
    public static final String MIN_X = "minX";
    public static final String MAX_X = "maxX";
    public static final String MIN_Y = "minY";
    public static final String MAX_Y = "maxY";
    public static final String XSIZE = "xGridSize";
    public static final String YSIZE = "yGridSize";
    protected static ElementRule boundingBoxRules = new ElementRule("boundingBox", new XMLSyntaxRule[]{AttributeRule.newDoubleRule("minX"), AttributeRule.newDoubleRule("maxX"), AttributeRule.newDoubleRule("minY"), AttributeRule.newDoubleRule("maxY")});
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class), AttributeRule.newStringRule("cartogramFileName", true), AttributeRule.newIntegerRule("xGridSize"), AttributeRule.newIntegerRule("yGridSize"), boundingBoxRules};

        @Override
        public String getParserName() {
            return CartogramDiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Rectangle2D rectangle2D = CartogramDiffusionModel.parseRectangle2D(xMLObject);
            CartogramMapping cartogramMapping = CartogramDiffusionModel.parseCartogramMapping(xMLObject, rectangle2D);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            CartogramDiffusionModel cartogramDiffusionModel = new CartogramDiffusionModel(xMLObject.getId(), parameter);
            cartogramDiffusionModel.addMapping(cartogramMapping);
            return cartogramDiffusionModel;
        }

        @Override
        public String getParserDescription() {
            return "Describes a bivariate diffusion process using cartogram distances.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };
    private Parameter precision;
    private CartogramMapping mapping;

    public CartogramDiffusionModel(String string, Parameter parameter) {
        this.precision = parameter;
        this.addVariable(parameter);
        this.setId(string);
        Logger.getLogger("dr.evomodel.continuous").info("Constructing cartogram diffusion model '" + this.getId() + "': \n\tIf you use this model, please reference: Lemey, Drummond and Suchard (in preparation)\n\tPrecision: " + parameter.getId());
    }

    public void addMapping(CartogramMapping cartogramMapping) {
        this.mapping = cartogramMapping;
        Logger.getLogger("dr.evomodel.continuous").info("\tMapping  : " + cartogramMapping.toString() + "\n");
    }

    protected CartogramMapping getMapping() {
        return this.mapping;
    }

    @Override
    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        Point2D.Double double_2 = new Point2D.Double(dArray2[0], dArray2[1]);
        CartogramMapping cartogramMapping = this.getMapping();
        Point2D point2D = cartogramMapping.map(double_);
        Point2D point2D2 = cartogramMapping.map(double_2);
        if (point2D == null || point2D2 == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = cartogramMapping.getAverageDensity();
        double d3 = point2D2.distance(point2D);
        double d4 = this.precision.getParameterValue(0) / d / Math.pow(d2, 0.25);
        return -LOG2PI + Math.log(d4) - 0.0 * Math.log(d2) - 0.5 * (d3 * d3 * d4);
    }

    @Override
    protected void calculatePrecisionInfo() {
    }

    public static Rectangle2D parseRectangle2D(XMLObject xMLObject) throws XMLParseException {
        XMLObject xMLObject2 = xMLObject.getChild(BOUNDING_BOX);
        double d = xMLObject2.getAttribute(MIN_X, 0.0);
        double d2 = xMLObject2.getAttribute(MAX_X, 0.0);
        double d3 = xMLObject2.getAttribute(MIN_Y, 0.0);
        double d4 = xMLObject2.getAttribute(MAX_Y, 0.0);
        if (d2 - d <= 0.0 || d4 - d3 <= 0.0) {
            throw new XMLParseException("Bounding box must contain volume");
        }
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public static CartogramMapping parseCartogramMapping(XMLObject xMLObject, Rectangle2D rectangle2D) throws XMLParseException {
        int n = xMLObject.getAttribute(XSIZE, 0);
        int n2 = xMLObject.getAttribute(YSIZE, 0);
        if (n <= 1 || n2 <= 1) {
            throw new XMLParseException("Strictly positive grid sizes required");
        }
        CartogramMapping cartogramMapping = new CartogramMapping(n, n2, rectangle2D);
        String string = xMLObject.getAttribute(FILENAME, "NONE");
        Logger.getLogger("dr.evomodel.continuous").info("Loading cartogram file: " + string + "\n");
        if (xMLObject.hasAttribute(FILENAME)) {
            try {
                cartogramMapping.readCartogramOutput(string);
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
        }
        double d = xMLObject.getAttribute(DENSITY, 1.0);
        cartogramMapping.setAverageDensity(d);
        return cartogramMapping;
    }
}

