/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.GMRFMultilocusSkyrideLikelihood;
import dr.evomodel.coalescent.GMRFSkygridLikelihood;
import dr.evomodel.coalescent.MultilocusNonparametricCoalescentLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModel;
import dr.util.Transform;

public class PopSizesLogger
implements Loggable {
    private final Transform transform;
    private final String order;
    private final int popSizeDimension;
    private AbstractModel likelihood;

    public PopSizesLogger(MultilocusNonparametricCoalescentLikelihood multilocusNonparametricCoalescentLikelihood, Transform transform, String string) {
        this.transform = transform;
        this.order = string;
        this.popSizeDimension = multilocusNonparametricCoalescentLikelihood.getPopSizeDimension();
        this.likelihood = multilocusNonparametricCoalescentLikelihood;
    }

    public PopSizesLogger(GMRFSkygridLikelihood gMRFSkygridLikelihood, Transform transform, String string) {
        this.transform = transform;
        this.order = string;
        this.popSizeDimension = gMRFSkygridLikelihood.getDimension();
        this.likelihood = gMRFSkygridLikelihood;
    }

    public PopSizesLogger(GMRFMultilocusSkyrideLikelihood gMRFMultilocusSkyrideLikelihood, Transform transform, String string) {
        this.transform = transform;
        this.order = string;
        this.popSizeDimension = gMRFMultilocusSkyrideLikelihood.getDimension();
        this.likelihood = gMRFMultilocusSkyrideLikelihood;
    }

    private double getPopSize(int n) {
        if (this.likelihood instanceof MultilocusNonparametricCoalescentLikelihood) {
            return ((MultilocusNonparametricCoalescentLikelihood)this.likelihood).getPopulationSize(n);
        }
        if (this.likelihood instanceof GMRFSkygridLikelihood) {
            double d = ((GMRFSkygridLikelihood)this.likelihood).getParameter().getParameterValue(n);
            return Math.exp(d);
        }
        if (this.likelihood instanceof GMRFMultilocusSkyrideLikelihood) {
            double d = ((GMRFMultilocusSkyrideLikelihood)this.likelihood).getParameter().getParameterValue(n);
            return Math.exp(d);
        }
        throw new RuntimeException("Likelihood type not yet implemented.");
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.popSizeDimension];
        for (int i = 0; i < this.popSizeDimension; ++i) {
            final int n = i;
            logColumnArray[i] = new NumberColumn("PopSize." + (n + 1)){

                @Override
                public double getDoubleValue() {
                    if (PopSizesLogger.this.transform != null) {
                        return PopSizesLogger.this.transform.transform(PopSizesLogger.this.getPopSize(n));
                    }
                    return PopSizesLogger.this.getPopSize(n);
                }
            };
        }
        return logColumnArray;
    }
}

