/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchmodel.BranchSpecificBranchModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class EstimableStemWeightBranchSpecificBranchModel
extends BranchSpecificBranchModel {
    private final List<Parameter> stemWeightParameters = new ArrayList<Parameter>();
    protected Map<BitSet, Integer> stemWeightMap = new HashMap<BitSet, Integer>();
    private boolean hasBackbone = false;

    public EstimableStemWeightBranchSpecificBranchModel(TreeModel treeModel, SubstitutionModel substitutionModel) {
        super(treeModel, substitutionModel);
    }

    public void checkValidityOfBranchAssignments() {
        if (this.hasBackbone) {
            throw new RuntimeException("Not implemented yet");
        }
        if (this.clades.size() > 1) {
            for (Object object : this.clades.keySet()) {
                for (BitSet bitSet : this.clades.keySet()) {
                    if (((BitSet)object).equals(bitSet) || !((BitSet)object).intersects(bitSet)) continue;
                    throw new RuntimeException("Overlapping clades are not allowed.");
                }
            }
        }
        Map<NodeRef, BranchModel.Mapping> map = this.getExternalNodeMap();
        if (this.clades.size() > 0 && map.size() > 0) {
            for (Object object : map.keySet()) {
                int n = object.getNumber();
                for (BitSet bitSet : this.clades.keySet()) {
                    if (!bitSet.get(n)) continue;
                    throw new RuntimeException("Overlapping tip sets and clades are not allowed.");
                }
            }
        }
    }

    public void addClade(TaxonList taxonList, SubstitutionModel substitutionModel, Parameter parameter) throws TreeUtils.MissingTaxonException {
        List<SubstitutionModel> list = this.getSubstitutionModels();
        int n = list.indexOf(substitutionModel);
        if (n == -1) {
            n = list.size();
            list.add(substitutionModel);
            this.addModel(substitutionModel);
        }
        BitSet bitSet = TreeUtils.getTipsBitSetForTaxa(this.getTreeModel(), taxonList);
        BranchSpecificBranchModel.Clade clade = new BranchSpecificBranchModel.Clade(n, bitSet, parameter.getParameterValue(0));
        this.clades.put(bitSet, clade);
        this.setRequiresMatrixConvolution(true);
        int n2 = this.stemWeightParameters.indexOf(parameter);
        if (n2 == -1) {
            n2 = this.stemWeightParameters.size();
            this.stemWeightParameters.add(parameter);
            this.addVariable(parameter);
            this.stemWeightMap.put(bitSet, n2);
        }
        Logger.getLogger("dr.evomodel.branchmodel").info("\tAdding substitution model for clade defined by " + taxonList.getId() + " with variable stem-weight parameter " + parameter.getParameterName());
    }

    @Override
    public void addBackbone(TaxonList taxonList, SubstitutionModel substitutionModel) throws TreeUtils.MissingTaxonException {
        this.hasBackbone = true;
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable instanceof Parameter && this.stemWeightParameters.contains((Parameter)variable) && this.clades.size() > 0) {
            this.setUpdateNodeMaps(true);
        }
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    void setupNodeMaps() {
        if (this.clades.size() > 0) {
            this.clearNodeMaps();
            this.updateStemWeights();
            super.setupNodeMaps();
        }
        this.setUpdateNodeMaps(false);
    }

    @Override
    void processConvolvedBranch(NodeRef nodeRef, int n, double d) {
        this.setConvolvedNodeMap(nodeRef, n, 0, d);
    }

    void updateStemWeights() {
        double[] dArray = new double[this.stemWeightParameters.size()];
        for (int i = 0; i < this.stemWeightParameters.size(); ++i) {
            dArray[i] = this.stemWeightParameters.get(i).getParameterValue(0);
        }
        for (BitSet bitSet : this.clades.keySet()) {
            ((BranchSpecificBranchModel.Clade)this.clades.get(bitSet)).setStemWeight(dArray[this.stemWeightMap.get(bitSet)]);
        }
    }
}

