/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGTraceAnalysis;
import dr.evomodel.tree.TreeTraceAnalysis;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class ARGTraceAnalysisParser
extends AbstractXMLObjectParser {
    public static final String ARG_TRACE_ANALYSIS = "argTraceAnalysis";
    public static final String BURN_IN = "burnIn";
    public static final String FILE_NAME = "fileName";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "name of a tree log file", "trees.log"), AttributeRule.newIntegerRule("burnIn", true)};

    @Override
    public String getParserName() {
        return ARG_TRACE_ANALYSIS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        try {
            FileReader fileReader;
            Object object;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                File file = new File(string);
                object = file.getName();
                String string2 = file.getParent();
                if (!file.isAbsolute()) {
                    string2 = System.getProperty("user.dir");
                }
                fileReader = new FileReader(new File(string2, (String)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            int n = -1;
            if (xMLObject.hasAttribute(BURN_IN)) {
                n = xMLObject.getIntegerAttribute(BURN_IN);
            }
            object = ARGTraceAnalysis.analyzeLogFile(new Reader[]{fileReader}, n, true);
            ((ARGTraceAnalysis)object).report();
            System.out.println();
            System.out.flush();
            return object;
        }
        catch (IOException iOException) {
            throw new XMLParseException(iOException.getMessage());
        }
    }

    @Override
    public String getParserDescription() {
        return "Analyses and reports on a trace consisting of trees.";
    }

    @Override
    public Class getReturnType() {
        return TreeTraceAnalysis.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

