/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.util.Identifiable;
import java.util.Map;
import java.util.TreeMap;

public class Location
implements Identifiable {
    public static final String LOCATION = "location";
    private final String id;
    private final int index;
    private final String description;
    private final double longitude;
    private final double latitude;
    private static Map<Integer, Location> locations = new TreeMap<Integer, Location>();

    private Location(String string, int n, String string2, double d, double d2) {
        this.id = string;
        this.index = n;
        this.description = string2;
        this.longitude = d;
        this.latitude = d2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
    }

    public String getDescription() {
        return this.description;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.getId();
    }

    public static Location newLocation(String string, String string2, double d, double d2) {
        if (Location.getLocation(string) != null) {
            throw new IllegalArgumentException("Location with id, " + string + ", already exists");
        }
        int n = Location.getLocationCount();
        Location location = new Location(string, n, string2, d, d2);
        locations.put(n, location);
        return location;
    }

    public static Location getLocation(String string) {
        for (Location location : locations.values()) {
            if (!location.getId().equals(string)) continue;
            return location;
        }
        return null;
    }

    public static int getLocationCount() {
        return locations.keySet().size();
    }

    public static Location getLocation(int n) {
        return locations.get(n);
    }
}

