/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

public class AminoAcids
extends DataType {
    public static final String DESCRIPTION = "amino acid";
    public static final int TYPE = 1;
    public static final AminoAcids INSTANCE = new AminoAcids();
    public static final char STOP_CHARACTER = '*';
    public static final int STOP_STATE = 23;
    public static final int UNKNOWN_STATE = 24;
    public static final int GAP_STATE = 25;
    public static final int AMINOACIDS = 1;
    public static final char[] AMINOACID_CHARS = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y', 'B', 'Z', 'X', '*', '?', '-'};
    private static final String[] AMINOACID_TRIPLETS = new String[]{"Ala", "Cys", "Asp", "Glu", "Phe", "Gly", "His", "Ile", "Lys", "Leu", "Met", "Asn", "Pro", "Gln", "Arg", "Ser", "Thr", "Val", "Trp", "Tyr", "Asx", "Glx", " X ", " * ", " ? ", " - "};
    public static final int[] AMINOACID_STATES = new int[]{25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 23, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 24, 25, 0, 20, 1, 2, 3, 4, 5, 6, 7, 24, 8, 9, 10, 11, 24, 12, 13, 14, 15, 16, 24, 17, 18, 22, 19, 21, 25, 25, 25, 25, 25, 25, 0, 20, 1, 2, 3, 4, 5, 6, 7, 24, 8, 9, 10, 11, 24, 12, 13, 14, 15, 16, 24, 17, 18, 22, 19, 21, 25, 25, 25, 25, 25};
    private static final String[] AMINOACID_AMBIGUITIES = new String[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y", "DN", "EQ", "ACDEFGHIKLMNPQRSTVWY", "*", "ACDEFGHIKLMNPQRSTVWY", "ACDEFGHIKLMNPQRSTVWY"};

    protected AminoAcids() {
        this.stateCount = 20;
        this.ambiguousStateCount = 26;
    }

    @Override
    public char[] getValidChars() {
        return AMINOACID_CHARS;
    }

    @Override
    public int getState(char c) {
        return AMINOACID_STATES[c];
    }

    public static int getStopState() {
        return 23;
    }

    @Override
    public int getUnknownState() {
        return 24;
    }

    @Override
    public int getGapState() {
        return 25;
    }

    @Override
    public char getChar(int n) {
        return AMINOACID_CHARS[n];
    }

    @Override
    public String getTriplet(int n) {
        return AMINOACID_TRIPLETS[n];
    }

    @Override
    public int[] getStates(int n) {
        String string = AMINOACID_AMBIGUITIES[n];
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = this.getState(string.charAt(i));
        }
        return nArray;
    }

    @Override
    public boolean[] getStateSet(int n) {
        int n2;
        boolean[] blArray = new boolean[this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            blArray[n2] = false;
        }
        n2 = AMINOACID_AMBIGUITIES[n].length();
        for (int i = 0; i < n2; ++i) {
            blArray[this.getState((char)AminoAcids.AMINOACID_AMBIGUITIES[n].charAt((int)i))] = true;
        }
        return blArray;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 1;
    }

    public boolean isStopChar(char c) {
        return this.isStopState(this.getState(c));
    }

    public boolean isStopState(int n) {
        return n == AminoAcids.getStopState();
    }
}

