/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class StudentT
extends AbstractContinousDistribution {
    protected double freedom;
    protected double TERM;
    protected static StudentT shared = new StudentT(1.0, StudentT.makeDefaultGenerator());

    public StudentT(double d, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d);
    }

    public double cdf(double d) {
        return Probability.studentT(this.freedom, d);
    }

    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double d) {
        double d2;
        double d3;
        double d4;
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        while ((d4 = (d3 = 2.0 * this.randomGenerator.raw() - 1.0) * d3 + (d2 = 2.0 * this.randomGenerator.raw() - 1.0) * d2) > 1.0) {
        }
        return d3 * Math.sqrt(d * (Math.exp(-2.0 / d * Math.log(d4)) - 1.0) / d4);
    }

    public double pdf(double d) {
        return this.TERM * Math.pow(1.0 + d * d / this.freedom, -(this.freedom + 1.0) * 0.5);
    }

    public void setState(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = d;
        double d2 = Fun.logGamma((d + 1.0) / 2.0) - Fun.logGamma(d / 2.0);
        this.TERM = Math.exp(d2) / Math.sqrt(Math.PI * d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d) {
        StudentT studentT = shared;
        synchronized (studentT) {
            return shared.nextDouble(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.freedom + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        StudentT studentT = shared;
        synchronized (studentT) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

