/*
 * Decompiled with CFR 0.152.
 */
package beagle;

import beagle.BeagleFlag;

public class BenchmarkedResourceDetails {
    private final int number;
    private int resourceNumber;
    private String name;
    private String description;
    private long supportFlags;
    private long requiredFlags;
    private int returnCode;
    private String implName;
    private long benchedFlags;
    private double benchmarkResult;
    private double performanceRatio;

    public BenchmarkedResourceDetails(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    public int getResourceNumber() {
        return this.resourceNumber;
    }

    public void setResourceNumber(int n) {
        this.resourceNumber = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public long getSupportFlags() {
        return this.supportFlags;
    }

    public void setSupportFlags(long l) {
        this.supportFlags = l;
    }

    public long getRequiredFlags() {
        return this.requiredFlags;
    }

    public void setRequiredFlags(long l) {
        this.requiredFlags = l;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int n) {
        this.returnCode = n;
    }

    public String getImplName() {
        return this.implName;
    }

    public void setImplName(String string) {
        this.implName = string;
    }

    public long getBenchedFlags() {
        return this.benchedFlags;
    }

    public void setBenchedFlags(long l) {
        this.benchedFlags = l;
    }

    public double getBenchmarkResult() {
        return this.benchmarkResult;
    }

    public void setBenchmarkResult(double d) {
        this.benchmarkResult = d;
    }

    public double getPerformanceRatio() {
        return this.performanceRatio;
    }

    public void setPerformanceRatio(double d) {
        this.performanceRatio = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  Resource ").append(this.getResourceNumber()).append(": ").append(this.getName()).append("\n");
        if (this.getDescription() != null) {
            String[] stringArray;
            for (String string : stringArray = this.getDescription().split("\\|")) {
                if (string.trim().length() <= 0) continue;
                stringBuilder.append("    ").append(string.trim()).append("\n");
            }
        }
        stringBuilder.append("    Benchmark Flags:");
        stringBuilder.append(BeagleFlag.toString(this.getBenchedFlags()));
        stringBuilder.append("\n");
        stringBuilder.append("    Benchmark Result: ");
        stringBuilder.append(String.format("%.3f", this.getBenchmarkResult()));
        stringBuilder.append(" ms (");
        stringBuilder.append(String.format("%.2f", this.getPerformanceRatio()));
        stringBuilder.append("x CPU)");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

