## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# default:
#   autos:
#     projects: !expr list(
#       "DEV" = file.path("demo", "DEV", "username", "project1", "functions"),
#       "PROD" = file.path("demo", "PROD", "project1", "functions")
#       )

## -----------------------------------------------------------------------------
# create the temp directory
dir <- fs::file_temp()
dir.create(dir)
dir.create(file.path(dir, "/demo/PROD/project1/functions"), recursive = TRUE)

# write a function to the folder with an error
file_conn <- file(file.path(dir, "/demo/PROD/project1/functions/test_error.R"))
writeLines(
"test <- function(){print('test')", file_conn)
close(file_conn)

# write the config
config_path <- file.path(dir, "_envsetup.yml")
file_conn <- file(config_path)
writeLines(
  paste0(
"default:
  autos:
    PROD: '", dir,"/demo/PROD/project1/functions'"
  ), file_conn)
close(file_conn)

## ----error = TRUE-------------------------------------------------------------
try({
library(envsetup)

envsetup_config <- config::get(file = config_path)

rprofile(envsetup_config)
})

## ----setup--------------------------------------------------------------------
safely_rprofile <- purrr::safely(rprofile)

ret <- safely_rprofile(envsetup_config)

## ----check--------------------------------------------------------------------
# check for errors and return if any occurred
if(!is.null(ret$error)) {
  print(ret$error)
}

## ----echo = FALSE-------------------------------------------------------------
unlink(dir, recursive=TRUE)

