/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BasicBrowserUI;
import ch.randelshofer.quaqua.util.ViewportPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;

public class QuaquaBrowserUI
extends BasicBrowserUI
implements ViewportPainter {
    private static JScrollBar verticalBar;
    private static CellRendererPane cellRendererPane;

    private static JScrollBar getVerticalBar() {
        if (verticalBar == null) {
            verticalBar = new JScrollBar(1, 0, 1, 0, 1){

                public boolean isShowing() {
                    return true;
                }

                protected void paintChildren(Graphics g) {
                    Component[] c = this.getComponents();
                    for (int i = 0; i < c.length; ++i) {
                        Graphics cg = g.create(c[i].getX(), c[i].getY(), c[i].getWidth(), c[i].getHeight());
                        c[i].paint(cg);
                        cg.dispose();
                    }
                }
            };
        }
        return verticalBar;
    }

    private static CellRendererPane getCellRendererPane() {
        if (cellRendererPane == null) {
            cellRendererPane = new CellRendererPane();
        }
        return cellRendererPane;
    }

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaBrowserUI();
    }

    public void paintViewport(Graphics g, JViewport c) {
        Dimension vs = c.getSize();
        Dimension bs = this.browser.getSize();
        JScrollBar vb = QuaquaBrowserUI.getVerticalBar();
        g.setColor(Color.black);
        Dimension ss = vb.getPreferredSize();
        if (bs.width < vs.width) {
            int fixedCellWidth = this.browser.getFixedCellWidth();
            try {
                vb.setSize(ss.width, vs.height);
                vb.doLayout();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int x = this.browser.getWidth() + fixedCellWidth; x < vs.width; x += fixedCellWidth + ss.width) {
                QuaquaBrowserUI.getCellRendererPane().paintComponent(g, vb, c, x, 0, ss.width, vs.height, false);
            }
        }
    }
}

