/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class EqualAreaProjection
extends NormalizedProjection {
    private static final long serialVersionUID = -6175270149094989517L;
    private static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    private transient double ci2;
    private transient double ci4;
    private transient double ci8;
    private transient double qmPolar;

    EqualAreaProjection(Initializer initializer) {
        super(initializer);
    }

    void computeCoefficients() {
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        this.ci2 = 0.10257936507936508 * d3 + 0.17222222222222222 * d2 + 0.3333333333333333 * d;
        this.ci4 = 0.0664021164021164 * d3 + 0.06388888888888888 * d2;
        this.ci8 = 0.01677689594356261 * d3;
        this.ci2 *= 2.0;
        this.ci4 *= 8.0;
        this.ci8 *= 64.0;
        this.qmPolar = this.qm(1.0);
    }

    EqualAreaProjection(EqualAreaProjection equalAreaProjection) {
        super(equalAreaProjection);
        this.ci2 = equalAreaProjection.ci2;
        this.ci4 = equalAreaProjection.ci4;
        this.ci8 = equalAreaProjection.ci8;
        this.qmPolar = equalAreaProjection.qmPolar;
    }

    final double qm(double d) {
        return this.eccentricity == 0.0 ? 2.0 * d : this.qm_ellipsoid(d);
    }

    final double qm_ellipsoid(double d) {
        double d2 = this.eccentricity * d;
        return d / (1.0 - d2 * d2) + MathFunctions.atanh(d2) / this.eccentricity;
    }

    final double dqm_d\u03c6(double d, double d2) {
        double d3 = 1.0 - this.eccentricitySquared * (d * d);
        return 2.0 * d2 / (d3 * d3);
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2 = d / this.qmPolar;
        double d3 = Math.asin(d2);
        double d4 = d2 * d2;
        double d5 = 1.0 - d4;
        double d6 = d2 * Math.sqrt(d5);
        double d7 = 0.5 - d4;
        double d8 = (d5 - d4) * (d5 * d5 - d5 + 0.125);
        assert (ConformalProjection.identityEquals(d6, Math.sin(2.0 * d3) / 2.0));
        assert (ConformalProjection.identityEquals(d7, Math.sin(4.0 * d3) / (8.0 * d6)));
        assert (ConformalProjection.identityEquals(d8, Math.sin(8.0 * d3) / (64.0 * d6)));
        double d9 = (this.ci8 * d8 + this.ci4 * d7 + this.ci2) * d6 + d3;
        for (int i = 0; i < 15; ++i) {
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            double d12 = this.eccentricity * d10;
            double d13 = 1.0 - d12 * d12;
            double d14 = d13 * d13 / (2.0 * d11) * (d - d10 / d13 - MathFunctions.atanh(d12) / this.eccentricity);
            d9 += d14;
            if (!(Math.abs(d14) <= 3.926676682852614E-10)) continue;
            return d9;
        }
        double d15 = Math.abs(d2);
        if (Math.abs(d15 - 1.0) < 1.5706706731410455E-9) {
            return Math.copySign(1.5707963267948966, d);
        }
        if (d15 >= 1.0 || Double.isNaN(d)) {
            return Double.NaN;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeCoefficients();
    }
}

