/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class LinkOperation
extends AbstractOperation {
    private static final long serialVersionUID = 765096861589501215L;
    private final AbstractIdentifiedType result;
    final String referentName;

    LinkOperation(Map<String, ?> map, AbstractIdentifiedType abstractIdentifiedType) {
        super(map);
        if (abstractIdentifiedType instanceof LinkOperation) {
            abstractIdentifiedType = ((LinkOperation)abstractIdentifiedType).result;
        }
        this.result = abstractIdentifiedType;
        this.referentName = abstractIdentifiedType.getName().toString();
        if (this.referentName.equals(this.getName().toString())) {
            throw new IllegalArgumentException(Errors.format((short)18));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return FeatureUtilities.LINK_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.result;
    }

    @Override
    public Set<String> getDependencies() {
        return Collections.singleton(this.referentName);
    }

    @Override
    public Object apply(AbstractFeature abstractFeature, ParameterValueGroup parameterValueGroup) {
        ArgumentChecks.ensureNonNull("feature", abstractFeature);
        return abstractFeature.getProperty(this.referentName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.referentName.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.referentName.equals(((LinkOperation)object).referentName);
    }

    @Override
    void formatResultFormula(Appendable appendable) throws IOException {
        appendable.append(this.referentName);
    }
}

