# Generated by default/object.tt
package Paws::IoTEvents::AssetPropertyVariant;
  use Moose;
  has BooleanValue => (is => 'ro', isa => 'Str', request_name => 'booleanValue', traits => ['NameInRequest']);
  has DoubleValue => (is => 'ro', isa => 'Str', request_name => 'doubleValue', traits => ['NameInRequest']);
  has IntegerValue => (is => 'ro', isa => 'Str', request_name => 'integerValue', traits => ['NameInRequest']);
  has StringValue => (is => 'ro', isa => 'Str', request_name => 'stringValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::AssetPropertyVariant

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::AssetPropertyVariant object:

  $service_obj->Method(Att1 => { BooleanValue => $value, ..., StringValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::AssetPropertyVariant object:

  $result = $service_obj->Method(...);
  $result->Att1->BooleanValue

=head1 DESCRIPTION

A structure that contains an asset property value. For more
information, see Variant
(https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html)
in the I<AWS IoT SiteWise API Reference>.

You must use expressions for all parameters in C<AssetPropertyVariant>.
The expressions accept literals, operators, functions, references, and
substitution templates.

B<Examples>

=over

=item *

For literal values, the expressions must contain single quotes. For
example, the value for the C<integerValue> parameter can be C<'100'>.

=item *

For references, you must specify either variables or parameters. For
example, the value for the C<booleanValue> parameter can be
C<$variable.offline>.

=item *

For a substitution template, you must use C<${}>, and the template must
be in single quotes. A substitution template can also contain a
combination of literals, operators, functions, references, and
substitution templates.

In the following example, the value for the C<doubleValue> parameter
uses a substitution template.

C<'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'>

=back

For more information, see Expressions
(https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html)
in the I<AWS IoT Events Developer Guide>.

You must specify one of the following value types, depending on the
C<dataType> of the specified asset property. For more information, see
AssetProperty
(https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html)
in the I<AWS IoT SiteWise API Reference>.

=head1 ATTRIBUTES


=head2 BooleanValue => Str

The asset property value is a Boolean value that must be C<'TRUE'> or
C<'FALSE'>. You must use an expression, and the evaluated result should
be a Boolean value.


=head2 DoubleValue => Str

The asset property value is a double. You must use an expression, and
the evaluated result should be a double.


=head2 IntegerValue => Str

The asset property value is an integer. You must use an expression, and
the evaluated result should be an integer.


=head2 StringValue => Str

The asset property value is a string. You must use an expression, and
the evaluated result should be a string.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

