(* Copyright 1996-2003 John D. Polstra.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by John D. Polstra.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: IOWatchDog.i3,v 1.6 2003/03/04 19:26:23 jdp Exp $ *)

INTERFACE IOWatchDog;

IMPORT Rd, Time, Wr;

TYPE
  T <: Public;

  Public = Private OBJECT METHODS
    init(timeout: Time.T;
	 pollInterval: Time.T := 60.0d0): T;
    alert();
  END;

  Private <: ROOT;

(* The "init" method primes the watchdog timer to call its "alert" method
   after the interval "timeout" expires.  "pollInterval" is the number of
   seconds between polls conducted by the watchdog timer.

   The default "alert" method calls "Thread.Alert" on the thread that
   initialized the watchdog timer. *)

PROCEDURE AddRd(wd: T;
                rd: Rd.T);
(* Adds the given reader to the set monitored by the watchdog timer. *)

PROCEDURE AddWr(wd: T;
                wr: Wr.T);
(* Adds the given writer to the set monitored by the watchdog timer. *)

(* Both readers and writers are removed automatically when it is discovered
   that they are closed. *)

PROCEDURE Cancel(wd: T);
(* Cancels the watchdog timer. *)

PROCEDURE Expired(wd: T): BOOLEAN;
(* Returns "TRUE" if the watchdog timer has expired and alerted the target
   thread. *)

END IOWatchDog.
