/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class MenuManager
extends ContributionManager
implements IMenuManager {
    private String id;
    private ListenerList listeners = new ListenerList(1);
    private Menu menu = null;
    private MenuItem menuItem;
    private String menuText;
    private IContributionManagerOverrides overrides;
    private IContributionManager parent;
    private boolean removeAllWhenShown = false;
    private boolean visible = true;

    public MenuManager() {
        this(null, null);
    }

    public MenuManager(String text) {
        this(text, null);
    }

    public MenuManager(String text, String id) {
        this.menuText = text;
        this.id = id;
    }

    public void addMenuListener(IMenuListener listener) {
        this.listeners.add(listener);
    }

    public Menu createContextMenu(Control parent) {
        if (!this.menuExist()) {
            this.menu = new Menu(parent);
            this.initializeMenu();
        }
        return this.menu;
    }

    public Menu createMenuBar(Decorations parent) {
        if (!this.menuExist()) {
            this.menu = new Menu(parent, 2);
            this.update(false);
        }
        return this.menu;
    }

    public Menu createMenuBar(Shell parent) {
        return this.createMenuBar((Decorations)parent);
    }

    public void dispose() {
        if (this.menuExist()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.menuItem != null) {
            this.menuItem.dispose();
            this.menuItem = null;
        }
        IContributionItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
    }

    public void fill(Composite parent) {
    }

    public void fill(CoolBar parent, int index) {
    }

    public void fill(Menu parent, int index) {
        if (this.menuItem == null || this.menuItem.isDisposed()) {
            this.menuItem = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
            this.menuItem.setText(this.getMenuText());
            if (!this.menuExist()) {
                this.menu = new Menu(parent);
            }
            this.menuItem.setMenu(this.menu);
            this.initializeMenu();
            this.update(true);
        }
    }

    public void fill(ToolBar parent, int index) {
    }

    public IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    public IContributionItem findUsingPath(String path) {
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator == -1) {
            return super.find(path);
        }
        id = path.substring(0, separator);
        rest = path.substring(separator + 1);
        IContributionItem item = super.find(id);
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findUsingPath(rest);
        }
        return null;
    }

    private void fireAboutToShow(IMenuManager manager) {
        Object[] listeners = this.listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IMenuListener)listeners[i]).menuAboutToShow(manager);
        }
    }

    public String getId() {
        return this.id;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public String getMenuText() {
        return this.menuText;
    }

    public IContributionManagerOverrides getOverrides() {
        if (this.overrides == null) {
            this.overrides = this.parent == null ? new IContributionManagerOverrides(){

                public Integer getAccelerator(IContributionItem item) {
                    return null;
                }

                public String getAcceleratorText(IContributionItem item) {
                    return null;
                }

                public Boolean getEnabled(IContributionItem item) {
                    return null;
                }

                public String getText(IContributionItem item) {
                    return null;
                }
            } : this.parent.getOverrides();
            super.setOverrides(this.overrides);
        }
        return this.overrides;
    }

    public IContributionManager getParent() {
        return this.parent;
    }

    public boolean getRemoveAllWhenShown() {
        return this.removeAllWhenShown;
    }

    private void handleAboutToShow() {
        if (this.removeAllWhenShown) {
            this.removeAll();
        }
        this.fireAboutToShow(this);
        this.update(false, true);
    }

    private void initializeMenu() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                MenuManager.this.handleAboutToShow();
            }
        });
        this.markDirty();
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isGroupMarker() {
        return false;
    }

    public boolean isSeparator() {
        return false;
    }

    public boolean isSubstituteFor(IContributionItem item) {
        return this.equals(item);
    }

    public boolean isVisible() {
        if (!this.visible) {
            return false;
        }
        IContributionItem[] childItems = this.getItems();
        boolean visibleChildren = false;
        for (int j = 0; j < childItems.length; ++j) {
            if (!childItems[j].isVisible() || childItems[j].isSeparator()) continue;
            visibleChildren = true;
            break;
        }
        return visibleChildren;
    }

    private boolean menuExist() {
        return this.menu != null && !this.menu.isDisposed();
    }

    public void removeMenuListener(IMenuListener listener) {
        this.listeners.remove(listener);
    }

    public void saveWidgetState() {
    }

    public void setOverrides(IContributionManagerOverrides newOverrides) {
        this.overrides = newOverrides;
        super.setOverrides(this.overrides);
    }

    public void setParent(IContributionManager manager) {
        this.parent = manager;
    }

    public void setRemoveAllWhenShown(boolean removeAll) {
        this.removeAllWhenShown = removeAll;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void update() {
        this.updateMenuItem();
    }

    public void update(boolean force) {
        this.update(force, false);
    }

    protected void update(boolean force, boolean recursive) {
        if (this.isDirty() || force) {
            if (this.menuExist()) {
                IContributionItem[] items = this.getItems();
                ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
                IContributionItem separator = null;
                for (int i = 0; i < items.length; ++i) {
                    IContributionItem ci = items[i];
                    if (!ci.isVisible()) continue;
                    if (ci.isSeparator()) {
                        separator = ci;
                        continue;
                    }
                    if (separator != null) {
                        if (clean.size() > 0) {
                            clean.add(separator);
                        }
                        separator = null;
                    }
                    clean.add(ci);
                }
                MenuItem[] mi = this.menu.getItems();
                for (int i = 0; i < mi.length; ++i) {
                    Object data = mi[i].getData();
                    if (data == null || !clean.contains(data)) {
                        mi[i].dispose();
                        continue;
                    }
                    if (!(data instanceof IContributionItem) || !((IContributionItem)data).isDynamic() || !((IContributionItem)data).isDirty()) continue;
                    mi[i].dispose();
                }
                mi = this.menu.getItems();
                int srcIx = 0;
                int destIx = 0;
                Iterator e = clean.iterator();
                while (e.hasNext()) {
                    IContributionItem src = (IContributionItem)e.next();
                    IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                    if (dest != null && src.equals(dest)) {
                        ++srcIx;
                        ++destIx;
                    } else if (dest != null && dest.isSeparator() && src.isSeparator()) {
                        mi[srcIx].setData((Object)src);
                        ++srcIx;
                        ++destIx;
                    } else {
                        int start = this.menu.getItemCount();
                        src.fill(this.menu, destIx);
                        int newItems = this.menu.getItemCount() - start;
                        for (int i = 0; i < newItems; ++i) {
                            MenuItem item = this.menu.getItem(destIx++);
                            item.setData((Object)src);
                        }
                    }
                    if (!recursive) continue;
                    IContributionItem item = src;
                    if (item instanceof SubContributionItem) {
                        item = ((SubContributionItem)item).getInnerItem();
                    }
                    if (!(item instanceof IMenuManager)) continue;
                    ((IMenuManager)item).updateAll(force);
                }
                while (srcIx < mi.length) {
                    mi[srcIx].dispose();
                    ++srcIx;
                }
                this.setDirty(false);
            }
        } else if (recursive) {
            IContributionItem[] items = this.getItems();
            for (int i = 0; i < items.length; ++i) {
                IMenuManager mm;
                IContributionItem ci = items[i];
                if (!(ci instanceof IMenuManager) || !(mm = (IMenuManager)ci).isVisible()) continue;
                mm.updateAll(force);
            }
        }
        this.updateMenuItem();
    }

    public void update(String property) {
        IContributionItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].update(property);
        }
        if (this.menu != null && !this.menu.isDisposed() && this.menu.getParentItem() != null && "text".equals(property)) {
            String text = this.getOverrides().getText(this);
            if (text == null) {
                text = this.getMenuText();
            }
            if (text != null) {
                char character;
                int index;
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && (index = text.indexOf(38)) >= 0 && index < text.length() - 1 && callback.isAcceleratorInUse(0x10000 | (character = Character.toUpperCase(text.charAt(index + 1))))) {
                    text = index == 0 ? text.substring(1) : text.substring(0, index) + text.substring(index + 1);
                }
                this.menu.getParentItem().setText(text);
            }
        }
    }

    public void updateAll(boolean force) {
        this.update(force, true);
    }

    private void updateMenuItem() {
        if (this.menuItem != null && !this.menuItem.isDisposed() && this.menuExist()) {
            boolean enabled;
            boolean bl = enabled = this.menu.getItemCount() > 0;
            if (this.menuItem.getEnabled() != enabled) {
                Menu topMenu = this.menu;
                while (topMenu.getParentMenu() != null) {
                    topMenu = topMenu.getParentMenu();
                }
                if ((topMenu.getStyle() & 2) == 0) {
                    this.menuItem.setEnabled(enabled);
                }
            }
        }
    }
}

