/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class FilteredServiceListener
implements ServiceListener {
    protected FilterImpl filter;
    protected ServiceListener listener;

    protected FilteredServiceListener(String filterstring, ServiceListener listener) throws InvalidSyntaxException {
        this.filter = new FilterImpl(filterstring);
        this.listener = listener;
    }

    public void serviceChanged(ServiceEvent event) {
        String listenerName;
        ServiceReferenceImpl reference = (ServiceReferenceImpl)event.getServiceReference();
        if (Debug.DEBUG_EVENTS) {
            listenerName = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            Debug.println("filterServiceEvent(" + listenerName + ", \"" + this.filter + "\", " + reference.registration.properties + ")");
        }
        if (this.filter.match(reference)) {
            if (Debug.DEBUG_EVENTS) {
                listenerName = this.listener.getClass().getName() + "@" + Integer.toHexString(this.listener.hashCode());
                Debug.println("dispatchFilteredServiceEvent(" + listenerName + ")");
            }
            this.listener.serviceChanged(event);
        }
    }

    public String toString() {
        return this.filter.toString();
    }
}

