/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class ReentrantLock {
    private static final boolean DEBUG = Policy.DEBUG_THREADING;
    static final ISchedulingRule NULL_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }
    };
    private Map infos = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadInfo getThreadInfo() {
        Thread thisThread = Thread.currentThread();
        Map map = this.infos;
        synchronized (map) {
            ThreadInfo info = (ThreadInfo)this.infos.get(thisThread);
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadInfo getThreadInfo(IResource resource) {
        Map map = this.infos;
        synchronized (map) {
            Iterator iter = this.infos.values().iterator();
            while (iter.hasNext()) {
                ThreadInfo info = (ThreadInfo)iter.next();
                if (!info.ruleContains(resource)) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISchedulingRule acquire(ISchedulingRule resourceRule, IFlushOperation operation, IProgressMonitor monitor) {
        ThreadInfo info = this.getThreadInfo();
        boolean added = false;
        Map map = this.infos;
        synchronized (map) {
            if (info == null) {
                info = new ThreadInfo(operation);
                Thread thisThread = Thread.currentThread();
                this.infos.put(thisThread, info);
                added = true;
                if (DEBUG) {
                    System.out.println("[" + thisThread.getName() + "] acquired CVS lock on " + resourceRule);
                }
            }
        }
        try {
            return info.pushRule(resourceRule, monitor);
        }
        catch (OperationCanceledException e) {
            if (added) {
                Map map2 = this.infos;
                synchronized (map2) {
                    this.infos.remove(Thread.currentThread());
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ISchedulingRule rule, IProgressMonitor monitor) throws CVSException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Unmatched acquire/release.");
        Assert.isTrue(info.isNested(), "Unmatched acquire/release.");
        info.popRule(rule, monitor);
        Map map = this.infos;
        synchronized (map) {
            if (!info.isNested()) {
                Thread thisThread = Thread.currentThread();
                if (DEBUG) {
                    System.out.println("[" + thisThread.getName() + "] released CVS lock");
                }
                this.infos.remove(thisThread);
            }
        }
    }

    public void folderChanged(IContainer folder) {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Folder changed outside of resource lock");
        info.addChangedFolder(folder);
    }

    public void resourceChanged(IResource resource) {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Folder changed outside of resource lock");
        info.addChangedResource(resource);
    }

    public void flush(IProgressMonitor monitor) throws CVSException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Flush requested outside of resource lock");
        info.flush(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWithinActiveOperationScope(IResource resource) {
        Map map = this.infos;
        synchronized (map) {
            return this.getThreadInfo(resource) != null;
        }
    }

    public static interface IFlushOperation {
        public void flush(ThreadInfo var1, IProgressMonitor var2) throws CVSException;
    }

    public class ThreadInfo {
        private Set changedResources = new HashSet();
        private Set changedFolders = new HashSet();
        private IFlushOperation operation;
        private List rules = new ArrayList();

        public ThreadInfo(IFlushOperation operation) {
            this.operation = operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ISchedulingRule pushRule(ISchedulingRule resource, IProgressMonitor monitor) {
            ISchedulingRule rule = this.getRuleForResoure(resource);
            if (rule != NULL_SCHEDULING_RULE) {
                boolean success = false;
                try {
                    Platform.getJobManager().beginRule(rule, monitor);
                    this.addRule(rule);
                    return rule;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (success) throw throwable;
                    try {
                        Platform.getJobManager().endRule(rule);
                        throw throwable;
                    }
                    catch (RuntimeException e1) {
                        CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException(e1)));
                    }
                    throw throwable;
                }
            }
            this.addRule(rule);
            return rule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void popRule(ISchedulingRule rule, IProgressMonitor monitor) throws CVSException {
            ISchedulingRule stackedRule2;
            block6: {
                try {
                    if (this.isFlushRequired()) {
                        this.flush(monitor);
                    }
                    Object var4_3 = null;
                    stackedRule2 = this.removeRule();
                    if (rule != null) break block6;
                    rule = NULL_SCHEDULING_RULE;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ISchedulingRule stackedRule2 = this.removeRule();
                    if (rule == null) {
                        rule = NULL_SCHEDULING_RULE;
                    }
                    Assert.isTrue(stackedRule2.equals(rule), "end for resource '" + rule + "' does not match stacked rule '" + stackedRule2 + "'");
                    if (rule != NULL_SCHEDULING_RULE) {
                        Platform.getJobManager().endRule(rule);
                    }
                    throw throwable;
                }
            }
            Assert.isTrue(stackedRule2.equals(rule), "end for resource '" + rule + "' does not match stacked rule '" + stackedRule2 + "'");
            if (rule != NULL_SCHEDULING_RULE) {
                Platform.getJobManager().endRule(rule);
            }
        }

        private ISchedulingRule getRuleForResoure(ISchedulingRule resourceRule) {
            Object rule;
            if (resourceRule instanceof IResource) {
                IResource resource = (IResource)resourceRule;
                rule = resource.getType() == 8 ? NULL_SCHEDULING_RULE : (resource.getType() == 4 ? resource : resource.getParent());
            } else if (resourceRule instanceof MultiRule) {
                ISchedulingRule[] rules = ((MultiRule)resourceRule).getChildren();
                HashSet<IProject> projects = new HashSet<IProject>();
                for (int i = 0; i < rules.length; ++i) {
                    ISchedulingRule childRule = rules[i];
                    if (!(childRule instanceof IResource)) continue;
                    projects.add(((IResource)childRule).getProject());
                }
                rule = projects.isEmpty() ? NULL_SCHEDULING_RULE : (projects.size() == 1 ? (ISchedulingRule)projects.iterator().next() : new MultiRule(projects.toArray(new ISchedulingRule[projects.size()])));
            } else {
                rule = NULL_SCHEDULING_RULE;
            }
            return rule;
        }

        public boolean isNested() {
            return !this.rules.isEmpty();
        }

        public void addChangedResource(IResource resource) {
            this.changedResources.add(resource);
        }

        public void addChangedFolder(IContainer container) {
            this.changedFolders.add(container);
        }

        public boolean isEmpty() {
            return this.changedFolders.isEmpty() && this.changedResources.isEmpty();
        }

        public IResource[] getChangedResources() {
            return this.changedResources.toArray(new IResource[this.changedResources.size()]);
        }

        public IContainer[] getChangedFolders() {
            return this.changedFolders.toArray(new IContainer[this.changedFolders.size()]);
        }

        public void flush(IProgressMonitor monitor) throws CVSException {
            try {
                this.operation.flush(this, monitor);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Error e) {
                this.handleAbortedFlush(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.handleAbortedFlush(e);
                throw e;
            }
            finally {
                this.changedResources.clear();
                this.changedFolders.clear();
            }
        }

        private boolean isFlushRequired() {
            return this.rules.size() == 1 || this.remainingRulesAreNull();
        }

        private boolean remainingRulesAreNull() {
            for (int i = 0; i < this.rules.size() - 1; ++i) {
                ISchedulingRule rule = (ISchedulingRule)this.rules.get(i);
                if (rule == NULL_SCHEDULING_RULE) continue;
                return false;
            }
            return true;
        }

        private void handleAbortedFlush(Throwable t) {
            CVSProviderPlugin.log((IStatus)new CVSStatus(4, Policy.bind("ReentrantLock.9"), t));
        }

        private void addRule(ISchedulingRule rule) {
            this.rules.add(rule);
        }

        private ISchedulingRule removeRule() {
            return (ISchedulingRule)this.rules.remove(this.rules.size() - 1);
        }

        public boolean ruleContains(IResource resource) {
            Iterator iter = this.rules.iterator();
            while (iter.hasNext()) {
                ISchedulingRule rule = (ISchedulingRule)iter.next();
                if (rule == NULL_SCHEDULING_RULE || !rule.contains((ISchedulingRule)resource)) continue;
                return true;
            }
            return false;
        }
    }
}

