/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.util.HandleFactory;

public class SelectionRequestor
implements ISelectionRequestor {
    protected NameLookup nameLookup;
    protected Openable openable;
    protected IJavaElement[] elements = JavaElement.NO_ELEMENTS;
    protected int elementIndex = -1;
    protected HandleFactory handleFactory = new HandleFactory();

    public SelectionRequestor(NameLookup nameLookup, Openable openable) {
        this.nameLookup = nameLookup;
        this.openable = openable;
    }

    protected void acceptBinaryMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames) {
        IMethod method;
        String[] parameterTypes = null;
        if (parameterTypeNames != null) {
            parameterTypes = new String[parameterTypeNames.length];
            int max = parameterTypeNames.length;
            for (int i = 0; i < max; ++i) {
                String typeName;
                String pkg = "";
                if (parameterPackageNames[i] != null && parameterPackageNames[i].length > 0) {
                    pkg = new String(parameterPackageNames[i]) + ".";
                }
                if ((typeName = new String(parameterTypeNames[i])).indexOf(46) > 0) {
                    typeName = typeName.replace('.', '$');
                }
                parameterTypes[i] = Signature.createTypeSignature(pkg + typeName, true);
            }
        }
        if ((method = type.getMethod(new String(selector), parameterTypes)).exists()) {
            this.addElement(method);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(method.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptClass(char[] packageName, char[] className, boolean needQualification, boolean isDeclaration, int start, int end) {
        this.acceptType(packageName, className, 2, needQualification, isDeclaration, start, end);
    }

    public void acceptError(IProblem error) {
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, boolean isDeclaration, int start, int end) {
        if (isDeclaration) {
            IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 6, start, end);
            if (type != null) {
                try {
                    IField[] fields = type.getFields();
                    for (int i = 0; i < fields.length; ++i) {
                        IField field = fields[i];
                        ISourceRange range = field.getNameRange();
                        if (range.getOffset() > start || range.getOffset() + range.getLength() < end || !field.getElementName().equals(new String(name))) continue;
                        this.addElement(fields[i]);
                        if (SelectionEngine.DEBUG) {
                            System.out.print("SELECTION - accept field(");
                            System.out.print(field.toString());
                            System.out.println(")");
                        }
                        return;
                    }
                }
                catch (JavaModelException e) {
                    return;
                }
            }
        } else {
            IField field;
            IType type = this.resolveType(declaringTypePackageName, declaringTypeName, 6);
            if (type != null && (field = type.getField(new String(name))).exists()) {
                this.addElement(field);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept field(");
                    System.out.print(field.toString());
                    System.out.println(")");
                }
            }
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, boolean needQualification, boolean isDeclaration, int start, int end) {
        this.acceptType(packageName, interfaceName, 4, needQualification, isDeclaration, start, end);
    }

    public void acceptLocalField(SourceTypeBinding typeBinding, char[] name, CompilationUnitDeclaration parsedUnit) {
        IField field;
        IType type = (IType)this.handleFactory.createElement(typeBinding.scope.referenceContext, parsedUnit, this.openable);
        if (type != null && (field = type.getField(new String(name))).exists()) {
            this.addElement(field);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept field(");
                System.out.print(field.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalMethod(SourceTypeBinding typeBinding, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, boolean isConstructor, CompilationUnitDeclaration parsedUnit, boolean isDeclaration, int start, int end) {
        IType type = (IType)this.handleFactory.createElement(typeBinding.scope.referenceContext, parsedUnit, this.openable);
        if (type != null) {
            if (type.isBinary()) {
                IType declaringDeclaringType = type.getDeclaringType();
                boolean isStatic = false;
                try {
                    isStatic = Flags.isStatic(type.getFlags());
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
                if (declaringDeclaringType != null && isConstructor && !isStatic) {
                    int length = ((char[][])parameterPackageNames).length;
                    char[][] cArray = parameterPackageNames;
                    char[][] cArrayArray = new char[length + 1][];
                    parameterPackageNames = cArrayArray;
                    System.arraycopy(cArray, 0, cArrayArray, 1, length);
                    char[][] cArray2 = parameterTypeNames;
                    char[][] cArrayArray2 = new char[length + 1][];
                    parameterTypeNames = cArrayArray2;
                    System.arraycopy(cArray2, 0, cArrayArray2, 1, length);
                    parameterPackageNames[0] = declaringDeclaringType.getPackageFragment().getElementName().toCharArray();
                    parameterTypeNames[0] = declaringDeclaringType.getTypeQualifiedName().toCharArray();
                }
                this.acceptBinaryMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames);
            } else {
                this.acceptSourceMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames);
            }
        }
    }

    public void acceptLocalType(SourceTypeBinding typeBinding, CompilationUnitDeclaration parsedUnit) {
        IJavaElement type = this.handleFactory.createElement(typeBinding.scope.referenceContext, parsedUnit, this.openable);
        if (type != null) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept local type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptLocalVariable(LocalVariableBinding binding, CompilationUnitDeclaration parsedUnit) {
        IJavaElement localVar = this.handleFactory.createElement(binding.declaration, parsedUnit, this.openable);
        if (localVar != null) {
            this.addElement(localVar);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept local variable(");
                System.out.print(localVar.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, boolean isConstructor, boolean isDeclaration, int start, int end) {
        if (isDeclaration) {
            IType type = this.resolveTypeByLocation(declaringTypePackageName, declaringTypeName, 6, start, end);
            if (type != null) {
                this.acceptMethodDeclaration(type, selector, start, end);
            }
        } else {
            IType type = this.resolveType(declaringTypePackageName, declaringTypeName, 6);
            if (type != null) {
                if (type.isBinary()) {
                    IType declaringDeclaringType = type.getDeclaringType();
                    boolean isStatic = false;
                    try {
                        isStatic = Flags.isStatic(type.getFlags());
                    }
                    catch (JavaModelException e) {
                        // empty catch block
                    }
                    if (declaringDeclaringType != null && isConstructor && !isStatic) {
                        int length = ((char[][])parameterPackageNames).length;
                        char[][] cArray = parameterPackageNames;
                        char[][] cArrayArray = new char[length + 1][];
                        parameterPackageNames = cArrayArray;
                        System.arraycopy(cArray, 0, cArrayArray, 1, length);
                        char[][] cArray2 = parameterTypeNames;
                        char[][] cArrayArray2 = new char[length + 1][];
                        parameterTypeNames = cArrayArray2;
                        System.arraycopy(cArray2, 0, cArrayArray2, 1, length);
                        parameterPackageNames[0] = declaringDeclaringType.getPackageFragment().getElementName().toCharArray();
                        parameterTypeNames[0] = declaringDeclaringType.getTypeQualifiedName().toCharArray();
                    }
                    this.acceptBinaryMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames);
                } else {
                    this.acceptSourceMethod(type, selector, (char[][])parameterPackageNames, (char[][])parameterTypeNames);
                }
            }
        }
    }

    public void acceptPackage(char[] packageName) {
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(new String(packageName), false);
        if (pkgs != null) {
            int length = pkgs.length;
            for (int i = 0; i < length; ++i) {
                this.addElement(pkgs[i]);
                if (!SelectionEngine.DEBUG) continue;
                System.out.print("SELECTION - accept package(");
                System.out.print(pkgs[i].toString());
                System.out.println(")");
            }
        }
    }

    protected void acceptSourceMethod(IType type, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames) {
        String name = new String(selector);
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getElementName().equals(name) || methods[i].getParameterTypes().length != parameterTypeNames.length) continue;
                this.addElement(methods[i]);
            }
        }
        catch (JavaModelException e) {
            return;
        }
        if (this.elementIndex == -1) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
            return;
        }
        if (this.elementIndex == 0) {
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(this.elements[0].toString());
                System.out.println(")");
            }
            return;
        }
        IJavaElement[] matches = this.elements;
        int matchesIndex = this.elementIndex;
        this.elements = JavaElement.NO_ELEMENTS;
        this.elementIndex = -1;
        for (int i = 0; i <= matchesIndex; ++i) {
            IMethod method = (IMethod)matches[i];
            String[] signatures = method.getParameterTypes();
            boolean match = true;
            for (int p = 0; p < signatures.length; ++p) {
                char[] simpleParameterName;
                String simpleName = Signature.getSimpleName(Signature.toString(signatures[p]));
                if (simpleName.equals(new String(simpleParameterName = CharOperation.lastSegment(parameterTypeNames[p], '.')))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            this.addElement(method);
            if (!SelectionEngine.DEBUG) continue;
            System.out.print("SELECTION - accept method(");
            System.out.print(method.toString());
            System.out.println(")");
        }
    }

    protected void acceptMethodDeclaration(IType type, char[] selector, int start, int end) {
        String name = new String(selector);
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                ISourceRange range = methods[i].getNameRange();
                if (range.getOffset() > start || range.getOffset() + range.getLength() < end || !methods[i].getElementName().equals(name)) continue;
                this.addElement(methods[i]);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(this.elements[0].toString());
                    System.out.println(")");
                }
                return;
            }
        }
        catch (JavaModelException e) {
            return;
        }
        this.addElement(type);
        if (SelectionEngine.DEBUG) {
            System.out.print("SELECTION - accept type(");
            System.out.print(type.toString());
            System.out.println(")");
        }
    }

    protected void acceptType(char[] packageName, char[] typeName, int acceptFlags, boolean needQualification, boolean isDeclaration, int start, int end) {
        IType type = null;
        type = isDeclaration ? this.resolveTypeByLocation(packageName, typeName, acceptFlags, start, end) : this.resolveType(packageName, typeName, acceptFlags);
        if (type != null) {
            this.addElement(type);
            if (SelectionEngine.DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    protected void addElement(IJavaElement element) {
        int elementLength = this.elementIndex + 1;
        if (elementLength == this.elements.length) {
            this.elements = new IJavaElement[elementLength * 2 + 1];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        this.elements[++this.elementIndex] = element;
    }

    public IJavaElement[] getElements() {
        int elementLength = this.elementIndex + 1;
        if (this.elements.length != elementLength) {
            this.elements = new IJavaElement[elementLength];
            System.arraycopy(this.elements, 0, this.elements, 0, elementLength);
        }
        return this.elements;
    }

    protected IType resolveType(char[] packageName, char[] typeName, int acceptFlags) {
        IJavaElement type = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isWorkingCopy()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn('.', typeName);
                    if (compoundName.length > 0) {
                        type = wc.getType(new String(compoundName[0]));
                        int length = compoundName.length;
                        for (int i = 1; i < length; ++i) {
                            type = type.getType(new String(compoundName[i]));
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaModelException e) {
                type = null;
            }
        }
        if (type == null) {
            int length;
            IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int n = length = pkgs == null ? 0 : pkgs.length;
            for (int i = 0; i < length && (type = this.nameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags)) == null; ++i) {
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IType[] allTypes = null;
                    try {
                        ArrayList list = this.openable.getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    for (int i = 0; i < allTypes.length; ++i) {
                        if (!allTypes[i].getTypeQualifiedName().equals(tName)) continue;
                        return allTypes[i];
                    }
                }
            }
        }
        return type;
    }

    protected IType resolveTypeByLocation(char[] packageName, char[] typeName, int acceptFlags, int start, int end) {
        IJavaElement type = null;
        if (this.openable instanceof CompilationUnit && ((CompilationUnit)this.openable).isOpen()) {
            CompilationUnit wc = (CompilationUnit)this.openable;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn('.', typeName);
                    if (compoundName.length > 0) {
                        IType[] tTypes = wc.getTypes();
                        int i = 0;
                        int depth = 0;
                        while (i < tTypes.length) {
                            ISourceRange range = tTypes[i].getSourceRange();
                            if (range.getOffset() <= start && range.getOffset() + range.getLength() >= end && tTypes[i].getElementName().equals(new String(compoundName[depth]))) {
                                if (depth == compoundName.length - 1) {
                                    type = tTypes[i];
                                    break;
                                }
                                tTypes = tTypes[i].getTypes();
                                i = 0;
                                ++depth;
                                continue;
                            }
                            ++i;
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (JavaModelException e) {
                type = null;
            }
        }
        if (type == null) {
            int length;
            IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int n = length = pkgs == null ? 0 : pkgs.length;
            for (int i = 0; i < length && (type = this.nameLookup.findType(new String(typeName), pkgs[i], false, acceptFlags)) == null; ++i) {
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.openable != null && this.openable.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IType[] allTypes = null;
                    try {
                        ArrayList list = this.openable.getChildrenOfType(7);
                        allTypes = new IType[list.size()];
                        list.toArray(allTypes);
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    for (int i = 0; i < allTypes.length; ++i) {
                        if (!allTypes[i].getTypeQualifiedName().equals(tName)) continue;
                        return allTypes[i];
                    }
                }
            }
        }
        return type;
    }
}

