/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.compatibility;

import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.Policy;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class PluginActivator
implements BundleActivator {
    private BundleContext context;
    private Plugin plugin;
    private static ServiceTracker startLevelTracker = null;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public static StartLevel getStartLevel(BundleContext context) {
        if (startLevelTracker == null) {
            startLevelTracker = new ServiceTracker(context, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = PluginActivator.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null);
            startLevelTracker.open();
        }
        return (StartLevel)startLevelTracker.getService();
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        this.ensureNormalStartup(context);
        this.context = context;
        PluginDescriptor pd = (PluginDescriptor)Platform.getPluginRegistry().getPluginDescriptor(context.getBundle().getSymbolicName());
        this.plugin = pd.getPlugin();
        try {
            this.plugin.start(context);
            this.plugin.startup();
        }
        catch (Exception e) {
            this.plugin.shutdown();
            this.plugin.stop(context);
            pd.markAsDeactivated();
            throw e;
        }
    }

    private void ensureNormalStartup(BundleContext context) throws BundleException {
        StartLevel startLevel = PluginActivator.getStartLevel(context);
        if (startLevel == null) {
            return;
        }
        if (startLevel.getStartLevel() <= startLevel.getBundleStartLevel(context.getBundle())) {
            Status status = new Status(2, "org.eclipse.core.runtime", 0, Policy.bind("activator.applicationNotStarted", context.getBundle().getSymbolicName()), null);
            InternalPlatform.getDefault().log((IStatus)status);
            throw new BundleException(status.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.plugin.shutdown();
            this.plugin.stop(context);
            ((PluginDescriptor)this.plugin.getDescriptor()).doPluginDeactivation();
        }
        finally {
            this.context = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

