/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.comment;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.ui.text.comment.CommentLine;
import org.eclipse.jdt.internal.ui.text.comment.CommentRange;
import org.eclipse.jdt.internal.ui.text.comment.CommentRegion;
import org.eclipse.jdt.internal.ui.text.comment.ICommentAttributes;
import org.eclipse.jdt.internal.ui.text.comment.MultiCommentRegion;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.IJavaDocTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.ILinkTagConstants;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class MultiCommentLine
extends CommentLine
implements ICommentAttributes,
IHtmlTagConstants,
ILinkTagConstants,
IJavaDocTagConstants {
    public static final String MULTI_COMMENT_CONTENT_PREFIX = " * ";
    public static final String MULTI_COMMENT_END_PREFIX = " */";
    public static final String MULTI_COMMENT_START_PREFIX = "/* ";
    private String fReferenceIndentation = "";
    private static final Set fgTagLookup;

    protected MultiCommentLine(CommentRegion region) {
        super(region);
    }

    protected void adapt(CommentLine previous) {
        if (!(this.hasAttribute(2048) || this.hasAttribute(1024) || previous.hasAttribute(2))) {
            this.fReferenceIndentation = previous.getIndentationReference();
        }
    }

    protected void append(CommentRange range) {
        MultiCommentRegion parent = (MultiCommentRegion)this.getParent();
        if (range.hasAttribute(1024)) {
            this.setAttribute(1024);
        } else if (range.hasAttribute(2048)) {
            this.setAttribute(2048);
        } else if (range.hasAttribute(2)) {
            this.setAttribute(2);
        }
        int ranges = this.getSize();
        if (ranges == 1 && parent.isIndentRoots()) {
            CommentRange first = this.getFirst();
            String common = parent.getText(first.getOffset(), first.getLength()) + " ";
            if (this.hasAttribute(2048)) {
                this.fReferenceIndentation = common;
            } else if (this.hasAttribute(1024)) {
                this.fReferenceIndentation = parent.isIndentDescriptions() ? common + "\t" : common;
            }
        }
        super.append(range);
    }

    protected String getContentPrefix() {
        return MULTI_COMMENT_CONTENT_PREFIX;
    }

    protected String getEndingPrefix() {
        return MULTI_COMMENT_END_PREFIX;
    }

    protected final String getIndentationReference() {
        return this.fReferenceIndentation;
    }

    protected String getStartingPrefix() {
        return MULTI_COMMENT_START_PREFIX;
    }

    protected void scanLine(int line) {
        CommentRegion parent = this.getParent();
        String start = this.getStartingPrefix().trim();
        String end = this.getEndingPrefix().trim();
        String content = this.getContentPrefix().trim();
        int lines = parent.getSize();
        CommentRange range = this.getFirst();
        int offset = 0;
        int postfix = 0;
        String text = parent.getText(range.getOffset(), range.getLength());
        if (line == 0) {
            offset = text.indexOf(start);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if (offset >= 0) {
                range.trimBegin(offset += start.length());
                postfix = text.lastIndexOf(end);
                if (postfix >= 0 && text.substring(postfix + end.length()).trim().length() != 0) {
                    postfix = -1;
                }
                if (postfix >= offset) {
                    range.setLength(postfix - offset);
                } else {
                    postfix = text.lastIndexOf(content);
                    if (postfix >= 0 && text.substring(postfix + content.length()).trim().length() != 0) {
                        postfix = -1;
                    }
                    if (postfix >= offset) {
                        range.setLength(postfix - offset);
                        parent.setBorder(2);
                        if (postfix > offset) {
                            text = parent.getText(range.getOffset(), range.getLength());
                            IRegion region = this.trimLine(text, content);
                            range.move(region.getOffset());
                            range.setLength(region.getLength());
                        }
                    }
                }
            }
        } else if (line == lines - 1) {
            offset = text.indexOf(content);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if ((postfix = text.lastIndexOf(end)) >= 0 && text.substring(postfix + end.length()).trim().length() != 0) {
                postfix = -1;
            }
            if (offset >= 0 && offset == postfix) {
                range.setLength(0);
            } else {
                IRegion region;
                if (offset >= 0) {
                    range.trimBegin(offset + content.length());
                }
                if (postfix >= 0) {
                    range.trimEnd(-end.length());
                }
                if ((region = this.trimLine(text = parent.getText(range.getOffset(), range.getLength()), content)).getOffset() != 0 || region.getLength() != text.length()) {
                    range.move(region.getOffset());
                    range.setLength(region.getLength());
                    parent.setBorder(2);
                    parent.setBorder(1);
                }
            }
        } else {
            offset = text.indexOf(content);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if (offset >= 0) {
                range.trimBegin(offset += content.length());
            }
        }
    }

    protected void tokenizeLine(int line) {
        int offset;
        int index = offset = 0;
        CommentRegion parent = this.getParent();
        CommentRange range = this.getFirst();
        int begin = range.getOffset();
        String content = parent.getText(begin, range.getLength());
        int length = content.length();
        while (offset < length && Character.isWhitespace(content.charAt(offset))) {
            ++offset;
        }
        CommentRange result = null;
        if (offset >= length && !parent.isClearLines() && line > 0 && line < parent.getSize() - 1) {
            result = new CommentRange(begin, 0);
            result.setAttribute(2);
            result.setAttribute(8192);
            parent.append(result);
        }
        int attribute = 8192;
        while (offset < length) {
            while (offset < length && Character.isWhitespace(content.charAt(offset))) {
                ++offset;
            }
            index = offset;
            if (index < length) {
                if (content.charAt(index) == '<') {
                    int tag = ++index;
                    while (index < length && content.charAt(index) != '>' && content.charAt(index) != '<') {
                        ++index;
                    }
                    if (index < length && content.charAt(index) == '>' && this.isValidTag(content.substring(tag, index))) {
                        ++index;
                        attribute |= 0x20;
                    } else {
                        for (index = tag; index < length && !Character.isWhitespace(content.charAt(index)) && content.charAt(index) != '<' && !content.startsWith("{@", index); ++index) {
                        }
                    }
                } else if (content.startsWith("{@", index)) {
                    while (index < length && content.charAt(index) != '}') {
                        ++index;
                    }
                    if (index < length && content.charAt(index) == '}') {
                        ++index;
                    }
                    attribute |= 0x108;
                } else {
                    while (index < length && !Character.isWhitespace(content.charAt(index)) && content.charAt(index) != '<' && !content.startsWith("{@", index)) {
                        ++index;
                    }
                }
            }
            if (index - offset > 0) {
                result = new CommentRange(begin + offset, index - offset);
                result.setAttribute(attribute);
                parent.append(result);
                offset = index;
            }
            attribute = 0;
        }
    }

    private boolean isValidTag(String tag) {
        int i;
        if (tag.startsWith("/")) {
            tag = tag.substring(1, tag.length());
        }
        tag = tag.trim();
        for (i = 0; i < tag.length() && !Character.isWhitespace(tag.charAt(i)); ++i) {
        }
        tag = tag.substring(0, i);
        return this.isTagName(tag.toLowerCase());
    }

    private boolean isTagName(String tag) {
        return fgTagLookup.contains(tag);
    }

    protected final IRegion trimLine(String line, String trimmable) {
        int trim = trimmable.length();
        int offset = 0;
        int length = line.length() - trim;
        while (line.startsWith(trimmable, offset)) {
            offset += trim;
        }
        while (line.startsWith(trimmable, length)) {
            length -= trim;
        }
        return new Region(offset, length + trim);
    }

    static {
        int i;
        fgTagLookup = new HashSet();
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_BREAK_TAGS.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_BREAK_TAGS[i]);
        }
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_SINGLE_BREAK_TAG.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_SINGLE_BREAK_TAG[i]);
        }
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_CODE_TAGS.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_CODE_TAGS[i]);
        }
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS[i]);
        }
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_NEWLINE_TAGS.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_NEWLINE_TAGS[i]);
        }
        for (i = 0; i < IJavaDocTagConstants.JAVADOC_SEPARATOR_TAGS.length; ++i) {
            fgTagLookup.add(IJavaDocTagConstants.JAVADOC_SEPARATOR_TAGS[i]);
        }
    }
}

