/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.core.runtime.IPath;

class Diff {
    IPath fOldPath;
    IPath fNewPath;
    long fOldDate;
    long fNewDate;
    List fHunks = new ArrayList();
    boolean fMatches = false;
    private boolean fIsEnabled2 = true;
    String fRejected;

    Diff(IPath oldPath, long oldDate, IPath newPath, long newDate) {
        this.fOldPath = oldPath;
        this.fOldDate = oldPath == null ? 0L : oldDate;
        this.fNewPath = newPath;
        this.fNewDate = newPath == null ? 0L : newDate;
    }

    boolean isEnabled() {
        return this.fIsEnabled2;
    }

    void setEnabled(boolean b) {
        this.fIsEnabled2 = b;
    }

    void reverse() {
        IPath tp = this.fOldPath;
        this.fOldPath = this.fNewPath;
        this.fNewPath = tp;
        long t = this.fOldDate;
        this.fOldDate = this.fNewDate;
        this.fNewDate = t;
        Iterator iter = this.fHunks.iterator();
        while (iter.hasNext()) {
            Hunk hunk = (Hunk)iter.next();
            hunk.reverse();
        }
    }

    Hunk[] getHunks() {
        return this.fHunks.toArray(new Hunk[this.fHunks.size()]);
    }

    IPath getPath() {
        if (this.fOldPath != null) {
            return this.fOldPath;
        }
        return this.fNewPath;
    }

    void finish() {
        if (this.fHunks.size() == 1) {
            Hunk h = (Hunk)this.fHunks.get(0);
            if (h.fNewLength == 0) {
                this.fNewDate = 0L;
                this.fNewPath = this.fOldPath;
            }
        }
    }

    void add(Hunk hunk) {
        this.fHunks.add(hunk);
    }

    int getType() {
        if (this.fOldDate == 0L) {
            return 1;
        }
        if (this.fNewDate == 0L) {
            return 2;
        }
        return 3;
    }

    String getDescription(int strip) {
        IPath path = this.fOldPath;
        if (this.fOldDate == 0L) {
            path = this.fNewPath;
        }
        if (strip > 0 && strip < path.segmentCount()) {
            path = path.removeFirstSegments(strip);
        }
        return path.toOSString();
    }
}

