/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ZipFileStructureCreator;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

class ResourceCompareInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private boolean fThreeWay = false;
    private Object fRoot;
    private IStructureComparator fAncestor;
    private IStructureComparator fLeft;
    private IStructureComparator fRight;
    private IResource fAncestorResource;
    private IResource fLeftResource;
    private IResource fRightResource;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;
    static /* synthetic */ Class array$Lorg$eclipse$core$resources$IFile;

    ResourceCompareInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (ResourceCompareInput.this.fOpenAction == null) {
                    ResourceCompareInput.this.fOpenAction = (IAction)new Action(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$200(this.this$1, null);
                        }
                    };
                    Utilities.initAction(ResourceCompareInput.this.fOpenAction, this.getBundle(), "action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement te = ((MyDiffNode)element).getId();
                        if (te != null) {
                            enable = !"FOLDER".equals(te.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                ResourceCompareInput.this.fOpenAction.setEnabled(enable);
                manager.add(ResourceCompareInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }

            static /* synthetic */ void access$200(1 x0, SelectionEvent x1) {
                x0.handleOpen(x1);
            }
        };
        return this.fDiffViewer;
    }

    void setSelection(ISelection s) {
        IResource[] selection = Utilities.getResources(s);
        this.fThreeWay = selection.length == 3;
        this.fAncestorResource = null;
        this.fLeftResource = selection[0];
        this.fRightResource = selection[1];
        if (this.fThreeWay) {
            this.fLeftResource = selection[1];
            this.fRightResource = selection[2];
        }
        this.fAncestor = null;
        this.fLeft = this.getStructure(this.fLeftResource);
        this.fRight = this.getStructure(this.fRightResource);
        if (this.fThreeWay) {
            this.fAncestorResource = selection[0];
            this.fAncestor = this.getStructure(this.fAncestorResource);
        }
    }

    public boolean isEnabled(ISelection s) {
        IResource[] selection = Utilities.getResources(s);
        if (selection.length < 2 || selection.length > 3) {
            return false;
        }
        this.fThreeWay = selection.length == 3;
        this.fLeftResource = selection[0];
        this.fRightResource = selection[1];
        if (this.fThreeWay) {
            this.fLeftResource = selection[1];
            this.fRightResource = selection[2];
        }
        if (!this.comparable(this.fLeftResource, this.fRightResource)) {
            return false;
        }
        if (this.fThreeWay) {
            this.fAncestorResource = selection[0];
            if (!this.comparable(this.fLeftResource, this.fRightResource)) {
                return false;
            }
        }
        return true;
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeftResource != null) {
            cc.setLeftLabel(this.buildLabel(this.fLeftResource));
            cc.setLeftImage(CompareUIPlugin.getImage((IAdaptable)this.fLeftResource));
        }
        if (this.fRightResource != null) {
            cc.setRightLabel(this.buildLabel(this.fRightResource));
            cc.setRightImage(CompareUIPlugin.getImage((IAdaptable)this.fRightResource));
        }
        if (this.fThreeWay && this.fAncestorResource != null) {
            cc.setAncestorLabel(this.buildLabel(this.fAncestorResource));
            cc.setAncestorImage(CompareUIPlugin.getImage((IAdaptable)this.fAncestorResource));
        }
    }

    private boolean comparable(IResource c1, IResource c2) {
        return this.hasStructure(c1) == this.hasStructure(c2);
    }

    private boolean hasStructure(IResource input) {
        IFile file;
        String type;
        if (input instanceof IContainer) {
            return true;
        }
        if (input instanceof IFile && (type = (file = (IFile)input).getFileExtension()) != null) {
            return "JAR".equals(type = ResourceCompareInput.normalizeCase(type)) || "ZIP".equals(type);
        }
        return false;
    }

    private IStructureComparator getStructure(IResource input) {
        if (input instanceof IContainer) {
            return new FilteredBufferedResourceNode(input);
        }
        if (input instanceof IFile) {
            FilteredBufferedResourceNode rn = new FilteredBufferedResourceNode(input);
            IFile file = (IFile)input;
            String type = ResourceCompareInput.normalizeCase(file.getFileExtension());
            if ("JAR".equals(type) || "ZIP".equals(type)) {
                return new ZipFileStructureCreator().getStructure(rn);
            }
            return rn;
        }
        return null;
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            String title;
            String format;
            this.fLeftResource.refreshLocal(2, pm);
            this.fRightResource.refreshLocal(2, pm);
            if (this.fThreeWay && this.fAncestorResource != null) {
                this.fAncestorResource.refreshLocal(2, pm);
            }
            pm.beginTask(Utilities.getString("ResourceCompare.taskName"), -1);
            String leftLabel = this.fLeftResource.getName();
            String rightLabel = this.fRightResource.getName();
            if (this.fThreeWay) {
                format = Utilities.getString("ResourceCompare.threeWay.title");
                String ancestorLabel = this.fAncestorResource.getName();
                title = MessageFormat.format(format, ancestorLabel, leftLabel, rightLabel);
            } else {
                format = Utilities.getString("ResourceCompare.twoWay.title");
                title = MessageFormat.format(format, leftLabel, rightLabel);
            }
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(this.fThreeWay, pm, null, this.fAncestor, this.fLeft, this.fRight);
            return object;
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex);
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        if (this.fLeftResource != null && this.fRightResource != null) {
            String leftLabel = this.fLeftResource.getFullPath().makeRelative().toString();
            String rightLabel = this.fRightResource.getFullPath().makeRelative().toString();
            if (this.fThreeWay) {
                String format = Utilities.getString("ResourceCompare.threeWay.tooltip");
                String ancestorLabel = this.fAncestorResource.getFullPath().makeRelative().toString();
                return MessageFormat.format(format, ancestorLabel, leftLabel, rightLabel);
            }
            String format = Utilities.getString("ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    private String buildLabel(IResource r) {
        String n = r.getFullPath().toString();
        if (n.charAt(0) == '/') {
            return n.substring(1);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            block4: {
                try {
                    ResourceCompareInput.commit(pm, (DiffNode)this.fRoot);
                    Object var3_2 = null;
                    if (this.fDiffViewer == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.fDiffViewer != null) {
                        this.fDiffViewer.refresh();
                    }
                    this.setDirty(false);
                    throw throwable;
                }
                this.fDiffViewer.refresh();
            }
            this.setDirty(false);
            {
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                IDiffElement element = children[i];
                if (!(element instanceof DiffNode)) continue;
                ResourceCompareInput.commit(pm, (DiffNode)element);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if ((array$Lorg$eclipse$core$resources$IFile == null ? (array$Lorg$eclipse$core$resources$IFile = ResourceCompareInput.class$("[Lorg.eclipse.core.resources.IFile;")) : array$Lorg$eclipse$core$resources$IFile).equals(adapter)) {
            HashSet collector = new HashSet();
            this.collectDirtyResources(this.fRoot, collector);
            return collector.toArray(new IFile[collector.size()]);
        }
        return super.getAdapter(adapter);
    }

    private void collectDirtyResources(Object o, Set collector) {
        if (o instanceof DiffNode) {
            IDiffElement[] children;
            IResource resource;
            BufferedResourceNode bn;
            ITypedElement right;
            IResource resource2;
            BufferedResourceNode bn2;
            DiffNode node = (DiffNode)o;
            ITypedElement left = node.getLeft();
            if (left instanceof BufferedResourceNode && (bn2 = (BufferedResourceNode)left).isDirty() && (resource2 = bn2.getResource()) instanceof IFile) {
                collector.add(resource2);
            }
            if ((right = node.getRight()) instanceof BufferedResourceNode && (bn = (BufferedResourceNode)right).isDirty() && (resource = bn.getResource()) instanceof IFile) {
                collector.add(resource);
            }
            if ((children = node.getChildren()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    IDiffElement element = children[i];
                    if (!(element instanceof DiffNode)) continue;
                    this.collectDirtyResources(element, collector);
                }
            }
        }
    }

    private static String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FilteredBufferedResourceNode
    extends BufferedResourceNode {
        FilteredBufferedResourceNode(IResource resource) {
            super(resource);
        }

        protected IStructureComparator createChild(IResource child) {
            String name = child.getName();
            if (CompareUIPlugin.getDefault().filter(name, child instanceof IContainer, false)) {
                return null;
            }
            return new FilteredBufferedResourceNode(child);
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty = false;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
            ResourceCompareInput.this.setDirty(true);
            this.fDirty = true;
            if (ResourceCompareInput.this.fDiffViewer != null) {
                ResourceCompareInput.this.fDiffViewer.refresh(this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return '<' + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

