/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.model.AbstractEditingModel;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLEditingModel
extends AbstractEditingModel {
    private SAXParser fParser;

    public XMLEditingModel(IDocument document, boolean isReconciling) {
        super(document, isReconciling);
    }

    public void load(InputStream source, boolean outOfSync) {
        try {
            this.fLoaded = true;
            this.getParser().parse(source, this.createDocumentHandler(this));
        }
        catch (SAXException e) {
            this.fLoaded = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void adjustOffsets(IDocument document) {
        try {
            this.getParser().parse(this.getInputStream(document), this.createNodeOffsetHandler(this));
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract DefaultHandler createNodeOffsetHandler(IModel var1);

    protected abstract DefaultHandler createDocumentHandler(IModel var1);

    private SAXParser getParser() {
        try {
            if (this.fParser == null) {
                this.fParser = SAXParserFactory.newInstance().newSAXParser();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fParser;
    }
}

