/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.search.ui.text.Match;

/**
 */
public class NLSSearchEditorOpener extends JavaSearchEditorOpener {
	protected Object getElementToOpen(Match match) {
		Object element= match.getElement();
		if (element instanceof IJavaElement) {
			return element;
		} else if (element instanceof FileEntry) {
			FileEntry fileEntry= (FileEntry) element;
			return fileEntry.getPropertiesFile();
		}
		// this should not happen
		return null;
	}
}
