/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.Compression;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.PortWatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserAuthKeyboardInteractive;
import com.jcraft.jsch.UserAuthNone;
import com.jcraft.jsch.UserAuthPassword;
import com.jcraft.jsch.UserAuthPublicKey;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Session
implements Runnable {
    private static final String version = "JSCH-0.1.16";
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEXINIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int SSH_MSG_USERAUTH_REQUEST = 50;
    static final int SSH_MSG_USERAUTH_FAILURE = 51;
    static final int SSH_MSG_USERAUTH_SUCCESS = 52;
    static final int SSH_MSG_USERAUTH_BANNER = 53;
    static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    static final int SSH_MSG_USERAUTH_PK_OK = 60;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    private byte[] V_S;
    private byte[] V_C = "SSH-2.0-JSCH-0.1.16".getBytes();
    private byte[] I_C;
    private byte[] I_S;
    private byte[] K_S;
    private byte[] session_id;
    private byte[] IVc2s;
    private byte[] IVs2c;
    private byte[] Ec2s;
    private byte[] Es2c;
    private byte[] MACc2s;
    private byte[] MACs2c;
    private int seqi = 0;
    private int seqo = 0;
    private Cipher s2ccipher;
    private Cipher c2scipher;
    private MAC s2cmac;
    private MAC c2smac;
    private byte[] mac_buf;
    private Compression deflater;
    private Compression inflater;
    private IO io;
    private Socket socket;
    private int timeout = 0;
    private boolean isConnected = false;
    InputStream in = null;
    OutputStream out = null;
    static Random random;
    Buffer buf;
    Packet packet;
    SocketFactory socket_factory = null;
    private Hashtable config = null;
    private Proxy proxy = null;
    private UserInfo userinfo;
    String host = "127.0.0.1";
    int port = 22;
    String username = null;
    String password = null;
    JSch jsch;
    private boolean in_kex = false;
    int[] uncompress_len = new int[1];
    Runnable thread;

    Session(JSch jSch) throws JSchException {
        this.jsch = jSch;
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        this.io = new IO();
    }

    public void connect() throws JSchException {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(this.getConfig("random"));
                random = (Random)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("connect: random " + exception);
            }
        }
        Packet.setRandom(random);
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            if (this.proxy == null) {
                this.proxy = this.jsch.getProxy(this.host);
                if (this.proxy != null) {
                    this.proxy.close();
                }
            }
            if (this.proxy == null) {
                OutputStream outputStream;
                if (this.socket_factory == null) {
                    if (this.timeout == 0) {
                        this.socket = new Socket(this.host, this.port);
                    } else {
                        final Socket[] socketArray = new Socket[1];
                        Thread thread = Thread.currentThread();
                        object3 = new Exception[1];
                        object2 = new boolean[]{false};
                        new Thread(new Runnable((boolean[])object2, thread, (Exception[])object3){
                            private final /* synthetic */ boolean[] val$done;
                            private final /* synthetic */ Thread val$thread;
                            private final /* synthetic */ Exception[] val$ee;
                            {
                                this.val$done = blArray;
                                this.val$thread = thread;
                                this.val$ee = exceptionArray;
                            }

                            public void run() {
                                try {
                                    socketArray[0] = new Socket(Session.this.host, Session.this.port);
                                    if (this.val$done[0]) {
                                        socketArray[0].close();
                                    } else {
                                        this.val$thread.interrupt();
                                    }
                                }
                                catch (Exception exception) {
                                    this.val$ee[0] = exception;
                                }
                            }
                        }).start();
                        try {
                            Thread.sleep(this.timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        object2[0] = true;
                        if (socketArray[0] != null) {
                            this.socket = socketArray[0];
                        } else {
                            String string = "socket is not established";
                            if (object3[0] != null) {
                                string = object3[0].toString();
                            }
                            throw new JSchException(string);
                        }
                    }
                    object = this.socket.getInputStream();
                    outputStream = this.socket.getOutputStream();
                } else {
                    this.socket = this.socket_factory.createSocket(this.host, this.port);
                    object = this.socket_factory.getInputStream(this.socket);
                    outputStream = this.socket_factory.getOutputStream(this.socket);
                }
                if (this.timeout > 0) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream((InputStream)object);
                this.io.setOutputStream(outputStream);
            } else {
                this.proxy.connect(this, this.host, this.port);
                this.io.setInputStream(this.proxy.getInputStream());
                this.io.setOutputStream(this.proxy.getOutputStream());
            }
            this.isConnected = true;
            for (n = 0; n < this.buf.buffer.length; ++n) {
                int n2 = this.io.getByte();
                this.buf.buffer[n] = (byte)n2;
                if (n2 != 10) continue;
            }
            if (this.buf.buffer[n - 1] == 10 && this.buf.buffer[--n - 1] == 13) {
                --n;
            }
            if (n == this.buf.buffer.length || n < 7 || this.buf.buffer[4] == 49 && this.buf.buffer[6] != 57) {
                throw new JSchException("invalid server's version string");
            }
            this.V_S = new byte[n];
            System.arraycopy(this.buf.buffer, 0, this.V_S, 0, n);
            this.io.put(this.V_C, 0, this.V_C.length);
            this.io.put("\n".getBytes(), 0, 1);
            this.buf = this.read(this.buf);
            if (this.buf.buffer[5] != 20) {
                throw new JSchException("invalid protocol: " + this.buf.buffer[5]);
            }
            object = this.receive_kexinit(this.buf);
            do {
                this.buf = this.read(this.buf);
                if (((KeyExchange)object).getState() == this.buf.buffer[5]) {
                    boolean bl2 = ((KeyExchange)object).next(this.buf);
                    if (bl2) continue;
                    throw new JSchException("verify: " + bl2);
                }
                throw new JSchException("invalid protocol(kex): " + this.buf.buffer[5]);
            } while (((KeyExchange)object).getState() != 0);
            this.checkHost(this.host, (KeyExchange)object);
            this.buf = this.read(this.buf);
            if (this.buf.buffer[5] != 21) {
                throw new JSchException("invalid protocol(newkyes): " + this.buf.buffer[5]);
            }
            this.receive_newkeys(this.buf, (KeyExchange)object);
            boolean bl3 = false;
            boolean bl4 = false;
            object3 = new UserAuthNone(this.userinfo);
            bl3 = ((UserAuthNone)object3).start(this);
            object2 = ((UserAuthNone)object3).getMethods();
            if (object2 == null) {
                object2 = "publickey,password,keyboard-interactive";
            }
            while (!bl3 && object2 != null && object2.length() > 0) {
                UserAuth userAuth = null;
                if (object2.startsWith("publickey")) {
                    if (this.jsch.identities.size() > 0) {
                        userAuth = new UserAuthPublicKey(this.userinfo);
                    }
                } else if (object2.startsWith("keyboard-interactive")) {
                    if (this.userinfo instanceof UIKeyboardInteractive) {
                        userAuth = new UserAuthKeyboardInteractive(this.userinfo);
                    }
                } else if (object2.startsWith("password")) {
                    userAuth = new UserAuthPassword(this.userinfo);
                }
                if (userAuth != null) {
                    try {
                        bl3 = ((UserAuth)userAuth).start(this);
                        bl4 = false;
                    }
                    catch (JSchAuthCancelException jSchAuthCancelException) {
                        bl4 = true;
                    }
                    catch (JSchPartialAuthException jSchPartialAuthException) {
                        object2 = jSchPartialAuthException.getMethods();
                        bl4 = false;
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl3) continue;
                int n3 = object2.indexOf(",");
                if (n3 == -1) break;
                object2 = object2.substring(n3 + 1);
            }
            if (bl3) {
                new Thread(this).start();
                return;
            }
            if (bl4) {
                throw new JSchException("Auth cancel");
            }
            throw new JSchException("Auth fail");
        }
        catch (Exception exception) {
            if (this.isConnected) {
                try {
                    this.packet.reset();
                    this.buf.putByte((byte)1);
                    this.buf.putInt(3);
                    this.buf.putString(exception.toString().getBytes());
                    this.buf.putString("en".getBytes());
                    this.write(this.packet);
                    this.disconnect();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            this.isConnected = false;
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException("Session.connect: " + exception);
        }
    }

    private KeyExchange receive_kexinit(Buffer buffer) throws Exception {
        int n = buffer.getInt();
        if (n != buffer.getLength()) {
            buffer.getByte();
            this.I_S = new byte[buffer.index - 5];
        } else {
            this.I_S = new byte[n - 1 - buffer.getByte()];
        }
        System.arraycopy(buffer.buffer, buffer.s, this.I_S, 0, this.I_S.length);
        this.send_kexinit();
        String[] stringArray = KeyExchange.guess(this.I_S, this.I_C);
        if (stringArray == null) {
            throw new JSchException("Algorithm negotiation fail");
        }
        KeyExchange keyExchange = null;
        try {
            Class<?> clazz = Class.forName(this.getConfig(stringArray[0]));
            keyExchange = (KeyExchange)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("kex: " + exception);
        }
        keyExchange.guess = stringArray;
        keyExchange.init(this, this.V_S, this.V_C, this.I_S, this.I_C);
        return keyExchange;
    }

    public void rekey() throws Exception {
        this.send_kexinit();
    }

    private void send_kexinit() throws Exception {
        if (this.in_kex) {
            return;
        }
        this.in_kex = true;
        this.packet.reset();
        this.buf.putByte((byte)20);
        random.fill(this.buf.buffer, this.buf.index, 16);
        this.buf.skip(16);
        this.buf.putString(this.getConfig("kex").getBytes());
        this.buf.putString(this.getConfig("server_host_key").getBytes());
        this.buf.putString(this.getConfig("cipher.c2s").getBytes());
        this.buf.putString(this.getConfig("cipher.s2c").getBytes());
        this.buf.putString(this.getConfig("mac.c2s").getBytes());
        this.buf.putString(this.getConfig("mac.s2c").getBytes());
        this.buf.putString(this.getConfig("compression.c2s").getBytes());
        this.buf.putString(this.getConfig("compression.s2c").getBytes());
        this.buf.putString(this.getConfig("lang.c2s").getBytes());
        this.buf.putString(this.getConfig("lang.s2c").getBytes());
        this.buf.putByte((byte)0);
        this.buf.putInt(0);
        this.buf.setOffSet(5);
        this.I_C = new byte[this.buf.getLength()];
        this.buf.getByte(this.I_C);
        this.write(this.packet);
    }

    private void send_newkeys() throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)21);
        this.write(this.packet);
    }

    private void checkHost(String string, KeyExchange keyExchange) throws JSchException {
        String string2 = this.getConfig("StrictHostKeyChecking");
        byte[] byArray = keyExchange.getHostKey();
        int n = this.jsch.getKnownHosts().check(string, byArray);
        if ((string2.equals("ask") || string2.equals("yes")) && n == 2) {
            String string3 = "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!     @\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!      \nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the " + keyExchange.getKeyType() + " host key has just been changed.\n" + "The fingerprint for the " + keyExchange.getKeyType() + " key sent by the remote host is\n" + keyExchange.getFingerPrint() + ".\n" + "Please contact your system administrator.\n" + "Add correct host key in " + this.jsch.getKnownHosts().getKnownHostsFile() + " to get rid of this message.";
            if (this.userinfo != null) {
                this.userinfo.showMessage(string3);
            }
            throw new JSchException("HostKey has been changed");
        }
        boolean bl = false;
        if ((string2.equals("ask") || string2.equals("yes")) && n != 0) {
            if (string2.equals("yes")) {
                throw new JSchException("reject HostKey");
            }
            if (this.userinfo != null) {
                boolean bl2 = this.userinfo.promptYesNo("The authenticity of host '" + string + "' can't be established.\n" + keyExchange.getKeyType() + " key fingerprint is " + keyExchange.getFingerPrint() + ".\n" + "Are you sure you want to continue connecting?");
                if (!bl2) {
                    throw new JSchException("reject HostKey");
                }
                bl = true;
            } else {
                if (n == 1) {
                    throw new JSchException("UnknownHostKey");
                }
                throw new JSchException("HostKey has been changed.");
            }
        }
        if (string2.equals("no") && n == 1) {
            bl = true;
        }
        if (bl) {
            this.jsch.getKnownHosts().insert(string, byArray);
            String string4 = this.jsch.getKnownHosts().getKnownHostsFile();
            if (string4 != null) {
                boolean bl3 = true;
                File file = new File(string4);
                if (!file.exists()) {
                    bl3 = false;
                    if (this.userinfo != null) {
                        bl3 = this.userinfo.promptYesNo(this.jsch.getKnownHosts().getKnownHostsFile() + " does not exist.\n" + "Are you sure you want to create it?");
                        file = file.getParentFile();
                        if (bl3 && file != null && !file.exists() && (bl3 = this.userinfo.promptYesNo("The parent directory " + file + " does not exist.\n" + "Are you sure you want to create it?"))) {
                            if (!file.mkdirs()) {
                                this.userinfo.showMessage(file + " has not been created.");
                                bl3 = false;
                            } else {
                                this.userinfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                            }
                        }
                        if (file == null) {
                            bl3 = false;
                        }
                    }
                }
                if (bl3) {
                    try {
                        this.jsch.getKnownHosts().sync(string4);
                    }
                    catch (Exception exception) {
                        System.out.println("sync known_hosts: " + exception);
                    }
                }
            }
        }
    }

    public Channel openChannel(String string) throws JSchException {
        if (!this.isConnected) {
            throw new JSchException("session is down");
        }
        try {
            Channel channel = Channel.getChannel(string);
            this.addChannel(channel);
            channel.init();
            return channel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void encode(Packet packet) throws Exception {
        if (this.deflater != null) {
            packet.buffer.index = this.deflater.compress(packet.buffer.buffer, 5, packet.buffer.index);
        }
        packet.padding();
        byte[] byArray = null;
        if (this.c2scipher != null) {
            byte by = packet.buffer.buffer[4];
            random.fill(packet.buffer.buffer, packet.buffer.index - by, by);
        }
        if (this.c2smac != null) {
            this.c2smac.update(this.seqo);
            this.c2smac.update(packet.buffer.buffer, 0, packet.buffer.index);
            byArray = this.c2smac.doFinal();
        }
        if (this.c2scipher != null) {
            byte[] byArray2 = packet.buffer.buffer;
            this.c2scipher.update(byArray2, 0, packet.buffer.index, byArray2, 0);
        }
        if (byArray != null) {
            packet.buffer.putByte(byArray);
        }
    }

    public Buffer read(Buffer buffer) throws Exception {
        int n = 0;
        while (true) {
            int n2;
            Object object;
            buffer.reset();
            this.io.getByte(buffer.buffer, buffer.index, 8);
            buffer.index += 8;
            if (this.s2ccipher != null) {
                this.s2ccipher.update(buffer.buffer, 0, 8, buffer.buffer, 0);
            }
            n = buffer.buffer[0] << 24 & 0xFF000000 | buffer.buffer[1] << 16 & 0xFF0000 | buffer.buffer[2] << 8 & 0xFF00 | buffer.buffer[3] & 0xFF;
            this.io.getByte(buffer.buffer, buffer.index, n - 4);
            buffer.index += n - 4;
            if (this.s2ccipher != null) {
                this.s2ccipher.update(buffer.buffer, 8, n - 4, buffer.buffer, 8);
            }
            if (this.s2cmac != null) {
                this.s2cmac.update(this.seqi);
                this.s2cmac.update(buffer.buffer, 0, buffer.index);
                byte[] byArray = this.s2cmac.doFinal();
                this.io.getByte(this.mac_buf, 0, this.mac_buf.length);
                if (!Arrays.equals(byArray, this.mac_buf)) {
                    System.out.println("mac error");
                    throw new IOException("MAC Error");
                }
            }
            ++this.seqi;
            if (this.inflater != null) {
                byte by = buffer.buffer[4];
                this.uncompress_len[0] = buffer.index - 5 - by;
                object = this.inflater.uncompress(buffer.buffer, 5, this.uncompress_len);
                if (object != null) {
                    buffer.buffer = object;
                    buffer.index = 5 + this.uncompress_len[0];
                } else {
                    System.err.println("fail in inflater");
                    break;
                }
            }
            if ((n2 = buffer.buffer[5] & 0xFF) == 1) {
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                int n3 = buffer.getInt();
                byte[] byArray = buffer.getString();
                byte[] byArray2 = buffer.getString();
                throw new JSchException("SSH_MSG_DISCONNECT: " + n3 + " " + new String(byArray) + " " + new String(byArray2));
            }
            if (n2 == 2) continue;
            if (n2 == 4) {
                buffer.rewind();
                buffer.getInt();
                buffer.getShort();
                continue;
            }
            if (n2 != 93) break;
            buffer.rewind();
            buffer.getInt();
            buffer.getShort();
            object = Channel.getChannel(buffer.getInt(), this);
            if (object == null) continue;
            object.addRemoteWindowSize(buffer.getInt());
        }
        buffer.rewind();
        return buffer;
    }

    byte[] getSessionId() {
        return this.session_id;
    }

    private void receive_newkeys(Buffer buffer, KeyExchange keyExchange) throws Exception {
        this.send_newkeys();
        this.in_kex = false;
        this.updateKeys(keyExchange);
    }

    private void updateKeys(KeyExchange keyExchange) throws Exception {
        int n;
        byte[] byArray = keyExchange.getK();
        byte[] byArray2 = keyExchange.getH();
        HASH hASH = keyExchange.getHash();
        String[] stringArray = keyExchange.guess;
        if (this.session_id == null) {
            this.session_id = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.session_id, 0, byArray2.length);
        }
        this.buf.reset();
        this.buf.putMPInt(byArray);
        this.buf.putByte(byArray2);
        this.buf.putByte((byte)65);
        this.buf.putByte(this.session_id);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVc2s = hASH.digest();
        int n2 = n = this.buf.index - this.session_id.length - 1;
        this.buf.buffer[n2] = (byte)(this.buf.buffer[n2] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.IVs2c = hASH.digest();
        int n3 = n;
        this.buf.buffer[n3] = (byte)(this.buf.buffer[n3] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Ec2s = hASH.digest();
        int n4 = n;
        this.buf.buffer[n4] = (byte)(this.buf.buffer[n4] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.Es2c = hASH.digest();
        int n5 = n;
        this.buf.buffer[n5] = (byte)(this.buf.buffer[n5] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACc2s = hASH.digest();
        int n6 = n;
        this.buf.buffer[n6] = (byte)(this.buf.buffer[n6] + 1);
        hASH.update(this.buf.buffer, 0, this.buf.index);
        this.MACs2c = hASH.digest();
        try {
            byte[] byArray3;
            Object object;
            Class<?> clazz = Class.forName(this.getConfig(stringArray[3]));
            this.s2ccipher = (Cipher)clazz.newInstance();
            while (this.s2ccipher.getBlockSize() > this.Es2c.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Es2c);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                object = hASH.digest();
                byArray3 = new byte[this.Es2c.length + ((byte[])object).length];
                System.arraycopy(this.Es2c, 0, byArray3, 0, this.Es2c.length);
                System.arraycopy(object, 0, byArray3, this.Es2c.length, ((byte[])object).length);
                this.Es2c = byArray3;
            }
            this.s2ccipher.init(1, this.Es2c, this.IVs2c);
            clazz = Class.forName(this.getConfig(stringArray[5]));
            this.s2cmac = (MAC)clazz.newInstance();
            this.s2cmac.init(this.MACs2c);
            this.mac_buf = new byte[this.s2cmac.getBlockSize()];
            clazz = Class.forName(this.getConfig(stringArray[2]));
            this.c2scipher = (Cipher)clazz.newInstance();
            while (this.c2scipher.getBlockSize() > this.Ec2s.length) {
                this.buf.reset();
                this.buf.putMPInt(byArray);
                this.buf.putByte(byArray2);
                this.buf.putByte(this.Ec2s);
                hASH.update(this.buf.buffer, 0, this.buf.index);
                object = hASH.digest();
                byArray3 = new byte[this.Ec2s.length + ((byte[])object).length];
                System.arraycopy(this.Ec2s, 0, byArray3, 0, this.Ec2s.length);
                System.arraycopy(object, 0, byArray3, this.Ec2s.length, ((byte[])object).length);
                this.Ec2s = byArray3;
            }
            this.c2scipher.init(0, this.Ec2s, this.IVc2s);
            clazz = Class.forName(this.getConfig(stringArray[4]));
            this.c2smac = (MAC)clazz.newInstance();
            this.c2smac.init(this.MACc2s);
            if (!stringArray[6].equals("none")) {
                object = this.getConfig(stringArray[6]);
                if (object != null) {
                    try {
                        clazz = Class.forName((String)object);
                        this.deflater = (Compression)clazz.newInstance();
                        this.deflater.init(1, 6);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " isn't accessible.");
                    }
                }
            } else if (this.deflater != null) {
                this.deflater = null;
            }
            if (!stringArray[7].equals("none")) {
                object = this.getConfig(stringArray[7]);
                if (object != null) {
                    try {
                        clazz = Class.forName((String)object);
                        this.inflater = (Compression)clazz.newInstance();
                        this.inflater.init(0, 0);
                    }
                    catch (Exception exception) {
                        System.err.println((String)object + " isn't accessible.");
                    }
                }
            } else if (this.inflater != null) {
                this.inflater = null;
            }
        }
        catch (Exception exception) {
            System.err.println("updatekeys: " + exception);
        }
    }

    public void write(Packet packet, Channel channel, int n) throws Exception {
        while (true) {
            if (channel.rwsize >= n) {
                channel.rwsize -= n;
                break;
            }
            if (channel.close || !this.isConnected()) {
                throw new IOException("channel is broken");
            }
            if (channel.rwsize > 0) {
                int n2 = channel.rwsize;
                int n3 = packet.shift(n2, this.c2smac != null ? this.c2smac.getBlockSize() : 0);
                byte by = packet.buffer.buffer[5];
                int n4 = channel.getRecipient();
                channel.rwsize = 0;
                this.write(packet);
                packet.unshift(by, n4, n3, n -= n2);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.write(packet);
    }

    public synchronized void write(Packet packet) throws Exception {
        this.encode(packet);
        if (this.io != null) {
            this.io.put(packet);
            ++this.seqo;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thread = this;
        Buffer buffer = new Buffer();
        Packet packet = new Packet(buffer);
        int n = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        KeyExchange keyExchange = null;
        try {
            block26: while (this.thread != null) {
                int n2;
                buffer = this.read(buffer);
                int n3 = buffer.buffer[5] & 0xFF;
                if (keyExchange != null && keyExchange.getState() == n3) {
                    n2 = keyExchange.next(buffer);
                    if (n2 != 0) continue;
                    throw new JSchException("verify: " + (n2 != 0));
                }
                switch (n3) {
                    case 20: {
                        System.out.println("KEXINIT");
                        keyExchange = this.receive_kexinit(buffer);
                        continue block26;
                    }
                    case 21: {
                        System.out.println("NEWKEYS");
                        this.receive_newkeys(buffer, keyExchange);
                        keyExchange = null;
                        continue block26;
                    }
                    case 94: {
                        buffer.getInt();
                        buffer.getByte();
                        buffer.getByte();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        byte[] byArray = buffer.getString(nArray, nArray2);
                        if (channel == null) continue block26;
                        try {
                            channel.write(byArray, nArray[0], nArray2[0]);
                        }
                        catch (Exception exception) {
                            try {
                                channel.disconnect();
                                continue block26;
                            }
                            catch (Exception exception2) {
                                continue block26;
                            }
                        }
                        n2 = nArray2[0];
                        channel.setLocalWindowSize(channel.lwsize - n2);
                        if (channel.lwsize >= channel.lwsize_max / 2) continue block26;
                        packet.reset();
                        buffer.putByte((byte)93);
                        buffer.putInt(channel.getRecipient());
                        buffer.putInt(channel.lwsize_max - channel.lwsize);
                        this.write(packet);
                        channel.setLocalWindowSize(channel.lwsize_max);
                        continue block26;
                    }
                    case 95: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        buffer.getInt();
                        byte[] byArray = buffer.getString(nArray, nArray2);
                        if (channel == null) continue block26;
                        channel.write_ext(byArray, nArray[0], nArray2[0]);
                        n2 = nArray2[0];
                        channel.setLocalWindowSize(channel.lwsize - n2);
                        if (channel.lwsize >= channel.lwsize_max / 2) continue block26;
                        packet.reset();
                        buffer.putByte((byte)93);
                        buffer.putInt(channel.getRecipient());
                        buffer.putInt(channel.lwsize_max - channel.lwsize);
                        this.write(packet);
                        channel.setLocalWindowSize(channel.lwsize_max);
                        continue block26;
                    }
                    case 93: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        channel.addRemoteWindowSize(buffer.getInt());
                        continue block26;
                    }
                    case 96: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        channel.eof();
                        continue block26;
                    }
                    case 97: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        channel.disconnect();
                        continue block26;
                    }
                    case 91: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) {
                            // empty if block
                        }
                        channel.setRecipient(buffer.getInt());
                        channel.setRemoteWindowSize(buffer.getInt());
                        channel.setRemotePacketSize(buffer.getInt());
                        continue block26;
                    }
                    case 92: {
                        int n4;
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) {
                            // empty if block
                        }
                        channel.exitstatus = n4 = buffer.getInt();
                        channel.close = true;
                        channel.eof = true;
                        channel.setRecipient(0);
                        continue block26;
                    }
                    case 98: {
                        boolean bl;
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        byte[] byArray = buffer.getString();
                        boolean bl2 = bl = buffer.getByte() != 0;
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        int n5 = 100;
                        if (new String(byArray).equals("exit-status")) {
                            n = buffer.getInt();
                            channel.setExitStatus(n);
                            n5 = 99;
                        }
                        if (!bl) continue block26;
                        packet.reset();
                        buffer.putByte((byte)n5);
                        buffer.putInt(channel.getRecipient());
                        this.write(packet);
                        continue block26;
                    }
                    case 90: {
                        buffer.getInt();
                        buffer.getShort();
                        byte[] byArray = buffer.getString();
                        String string = new String(byArray);
                        if (!"forwarded-tcpip".equals(string) && !"x11".equals(string)) {
                            System.out.println("Session.run: CHANNEL OPEN " + string);
                            throw new IOException("Session.run: CHANNEL OPEN " + string);
                        }
                        Channel channel = Channel.getChannel(string);
                        this.addChannel(channel);
                        channel.getData(buffer);
                        channel.init();
                        packet.reset();
                        buffer.putByte((byte)91);
                        buffer.putInt(channel.getRecipient());
                        buffer.putInt(channel.id);
                        buffer.putInt(channel.lwsize);
                        buffer.putInt(channel.lmpsize);
                        this.write(packet);
                        new Thread(channel).start();
                        continue block26;
                    }
                    case 99: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        channel.reply = 1;
                        continue block26;
                    }
                    case 100: {
                        buffer.getInt();
                        buffer.getShort();
                        n = buffer.getInt();
                        Channel channel = Channel.getChannel(n, this);
                        if (channel == null) continue block26;
                        channel.reply = 0;
                        continue block26;
                    }
                    case 80: {
                        buffer.getInt();
                        buffer.getShort();
                        byte[] byArray = buffer.getString();
                        boolean bl = buffer.getByte() != 0;
                        if (!bl) continue block26;
                        packet.reset();
                        buffer.putByte((byte)82);
                        this.write(packet);
                        continue block26;
                    }
                    case 81: 
                    case 82: {
                        continue block26;
                    }
                }
                System.out.println("Session.run: unsupported type " + n3);
                throw new IOException("Unknown SSH message type " + n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnect();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isConnected = false;
    }

    public void disconnect() {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        Channel.eof(this);
        PortWatcher.delPort(this);
        ChannelForwardedTCPIP.delPort(this);
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
            if (this.proxy == null) {
                if (this.socket != null) {
                    this.socket.close();
                }
            } else {
                this.proxy.close();
                this.proxy = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        this.socket = null;
        this.jsch.pool.removeElement(this);
    }

    public void setPortForwardingL(int n, String string, int n2) throws JSchException {
        this.setPortForwardingL("127.0.0.1", n, string, n2);
    }

    public void setPortForwardingL(String string, int n, String string2, int n2) throws JSchException {
        PortWatcher portWatcher = PortWatcher.addPort(this, string, n, string2, n2);
        new Thread(portWatcher).start();
    }

    public void delPortForwardingL(int n) throws JSchException {
        PortWatcher.delPort(this, n);
    }

    public String[] getPortForwardingL() throws JSchException {
        return PortWatcher.getPortForwarding(this);
    }

    public void setPortForwardingR(int n, String string, int n2) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, n, string, n2);
        Buffer buffer = new Buffer(100);
        Packet packet = new Packet(buffer);
        try {
            packet.reset();
            buffer.putByte((byte)80);
            buffer.putString("tcpip-forward".getBytes());
            buffer.putByte((byte)0);
            buffer.putString("0.0.0.0".getBytes());
            buffer.putInt(n);
            this.write(packet);
        }
        catch (Exception exception) {
            throw new JSchException(exception.toString());
        }
    }

    public void delPortForwardingR(int n) throws JSchException {
        ChannelForwardedTCPIP.delPort(this, n);
    }

    void addChannel(Channel channel) {
        channel.session = this;
    }

    public String getConfig(String string) {
        String string2 = null;
        if (this.config != null && (string2 = (String)this.config.get(string)) instanceof String) {
            return string2;
        }
        string2 = this.jsch.getConfig(string);
        if (string2 instanceof String) {
            return string2;
        }
        return null;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    void setUserName(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userinfo = userInfo;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setX11Host(String string) {
        ChannelX11.setHost(string);
    }

    public void setX11Port(int n) {
        ChannelX11.setPort(n);
    }

    public void setX11Cookie(String string) {
        ChannelX11.setCookie(string);
    }

    public void setConfig(Properties properties) {
        this.setConfig((Hashtable)properties);
    }

    public void setConfig(Hashtable hashtable) {
        if (this.config == null) {
            this.config = new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.config.put(string, (String)hashtable.get(string));
        }
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socket_factory = socketFactory;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) throws JSchException {
        if (this.socket == null) {
            if (n < 0) {
                throw new JSchException("invalid timeout value");
            }
            this.timeout = n;
            return;
        }
        try {
            this.socket.setSoTimeout(n);
            this.timeout = n;
        }
        catch (Exception exception) {
            throw new JSchException(exception.toString());
        }
    }

    public String getServerVersion() {
        return new String(this.V_S);
    }

    public String getClientVersion() {
        return new String(this.V_C);
    }

    public void setClientVersion(String string) {
        this.V_C = string.getBytes();
    }
}

