/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;

public class JavaReplaceWithEditionAction
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.ReplaceWithEditionAction";
    protected boolean fPrevious = false;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$BodyDeclaration;

    public JavaReplaceWithEditionAction() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISelection selection) {
        String errorTitle = CompareMessages.getString("ReplaceFromHistory.title");
        String errorMessage = CompareMessages.getString("ReplaceFromHistory.internalErrorMessage");
        Shell shell = this.getShell();
        IMember input = this.getEditionElement(selection);
        if (input == null) {
            String invalidSelectionMessage = CompareMessages.getString("ReplaceFromHistory.invalidSelectionMessage");
            MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
            return;
        }
        IFile file = this.getFile(input);
        if (file == null) {
            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
            return;
        }
        boolean inEditor = this.beingEdited(file);
        if (inEditor) {
            input = (IMember)this.getWorkingCopy((IJavaElement)input);
        }
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(file);
            if (!buffer.makeCommittable(shell).isOK()) {
                return;
            }
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            EditionSelectionDialog d = new EditionSelectionDialog(shell, bundle);
            d.setHelpContextId("org.eclipse.jdt.ui.replace_element_with_history_dialog_context");
            JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(buffer, inEditor);
            ITypedElement[] editions = this.buildEditions(target, file);
            ITypedElement ti = null;
            if (this.fPrevious) {
                ti = d.selectPreviousEdition((ITypedElement)target, editions, (Object)input);
                if (ti == null) {
                    MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)CompareMessages.getString("ReplaceFromHistory.parsingErrorMessage"));
                    return;
                }
            } else {
                ti = d.selectEdition((ITypedElement)target, editions, (Object)input);
            }
            if (ti instanceof IStreamContentAccessor) {
                JavaEditor je;
                String content = JavaCompareUtilities.readString((IStreamContentAccessor)ti);
                String newContent = JavaReplaceWithEditionAction.trimTextBlock(content, buffer.getLineDelimiter());
                if (newContent == null) {
                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                    return;
                }
                CompilationUnit root = JavaReplaceWithEditionAction.parsePartialCompilationUnit(input.getCompilationUnit(), 0, false);
                BodyDeclaration node = (BodyDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)root, input.getNameRange()), class$org$eclipse$jdt$core$dom$BodyDeclaration == null ? (class$org$eclipse$jdt$core$dom$BodyDeclaration = JavaReplaceWithEditionAction.class$("org.eclipse.jdt.core.dom.BodyDeclaration")) : class$org$eclipse$jdt$core$dom$BodyDeclaration);
                if (node == null) {
                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                    return;
                }
                OldASTRewrite rewriter = new OldASTRewrite((ASTNode)root);
                rewriter.replace((ASTNode)node, rewriter.createStringPlaceholder(newContent, node.getNodeType()), null);
                if (inEditor && (je = this.getEditor(file)) != null) {
                    je.setFocus();
                }
                this.applyChanges(rewriter, buffer, shell, inEditor);
            }
        }
        catch (InvocationTargetException ex) {
            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
        }
        catch (InterruptedException ex) {
            Assert.isTrue((boolean)false);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }

    protected ITypedElement[] buildEditions(ITypedElement target, IFile file, IFileState[] states) {
        ITypedElement[] editions = new ITypedElement[states.length + 1];
        editions[0] = new ResourceNode((IResource)file);
        for (int i = 0; i < states.length; ++i) {
            editions[i + 1] = new HistoryItem(target, states[i]);
        }
        return editions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

