/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

public class LexicalSortingAction
extends Action {
    private JavaElementSorter fSorter = new JavaElementSorter();
    private StructuredViewer fViewer;
    private String fPreferenceKey;

    public LexicalSortingAction(StructuredViewer viewer, String id) {
        this.fViewer = viewer;
        this.fPreferenceKey = "LexicalSortingAction." + id + ".isChecked";
        this.setText(JavaBrowsingMessages.getString("LexicalSortingAction.label"));
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
        this.setToolTipText(JavaBrowsingMessages.getString("LexicalSortingAction.tooltip"));
        this.setDescription(JavaBrowsingMessages.getString("LexicalSortingAction.description"));
        boolean checked = JavaPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
        this.valueChanged(checked, false);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.lexical_sorting_browsing_action");
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (on) {
                    LexicalSortingAction.this.fViewer.setSorter((ViewerSorter)LexicalSortingAction.this.fSorter);
                } else {
                    LexicalSortingAction.this.fViewer.setSorter(null);
                }
            }
        });
        if (store) {
            JavaPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, on);
        }
    }
}

