/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaIndenter;
import org.eclipse.jdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    private int fCaretOffset;
    private final boolean fIsTabAction;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$ui$text$SmartBackspaceManager;

    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean isTabAction) {
        super(bundle, prefix, editor);
        this.fIsTabAction = isTabAction;
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        final IDocument document = this.getDocument();
        if (document != null) {
            int nLines;
            int firstLine;
            final int offset = selection.getOffset();
            final int length = selection.getLength();
            final Position end = new Position(offset + length);
            this.fCaretOffset = -1;
            try {
                document.addPosition(end);
                firstLine = document.getLineOfOffset(offset);
                int minusOne = length == 0 ? 0 : 1;
                nLines = document.getLineOfOffset(offset + length - minusOne) - firstLine + 1;
            }
            catch (BadLocationException e) {
                JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)e));
                return;
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    IRewriteTarget target = (IRewriteTarget)IndentAction.this.getTextEditor().getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = IndentAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
                    if (target != null) {
                        target.beginCompoundChange();
                        target.setRedraw(false);
                    }
                    try {
                        try {
                            int newLength;
                            int newOffset;
                            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                            JavaIndenter indenter = new JavaIndenter(document, scanner);
                            boolean hasChanged = false;
                            for (int i = 0; i < nLines; hasChanged |= IndentAction.this.indentLine(document, firstLine + i, offset, indenter, scanner), ++i) {
                            }
                            if (IndentAction.this.fIsTabAction) {
                                newOffset = IndentAction.this.fCaretOffset;
                                newLength = 0;
                            } else if (nLines > 1) {
                                newOffset = offset;
                                newLength = end.getOffset() - offset;
                            } else {
                                newOffset = IndentAction.this.fCaretOffset;
                                newLength = 0;
                            }
                            if (newOffset != -1 && (hasChanged || newOffset != offset || newLength != length)) {
                                IndentAction.this.selectAndReveal(newOffset, newLength);
                            }
                            document.removePosition(end);
                        }
                        catch (BadLocationException e) {
                            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "ConcurrentModification in IndentAction", (Throwable)e));
                            Object var8_9 = null;
                            if (target == null) return;
                            target.endCompoundChange();
                            target.setRedraw(true);
                            return;
                        }
                        Object var8_8 = null;
                        if (target == null) return;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (target == null) throw throwable;
                        target.endCompoundChange();
                        target.setRedraw(true);
                        throw throwable;
                    }
                    target.endCompoundChange();
                    target.setRedraw(true);
                }
            };
            if (nLines > 50) {
                Display display = this.getTextEditor().getEditorSite().getWorkbenchWindow().getShell().getDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void selectAndReveal(int newOffset, int newLength) {
        Assert.isTrue((newOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((newLength >= 0 ? 1 : 0) != 0);
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof JavaEditor) {
            ISourceViewer viewer = ((JavaEditor)editor).getViewer();
            if (viewer != null) {
                viewer.setSelectedRange(newOffset, newLength);
            }
        } else {
            this.getTextEditor().selectAndReveal(newOffset, newLength);
        }
    }

    private boolean indentLine(IDocument document, int line, int caret, JavaIndenter indenter, JavaHeuristicScanner scanner) throws BadLocationException {
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            String type = partition.getType();
            if (type.equals("__java_javadoc") || type.equals("__java_multiline_comment")) {
                int to;
                int start = 0;
                if (line > 0) {
                    IRegion previousLine = document.getLineInformation(line - 1);
                    start = previousLine.getOffset() + previousLine.getLength();
                }
                DocumentCommand command = new DocumentCommand(){};
                command.text = "\n";
                command.offset = start;
                new JavaDocAutoIndentStrategy("___java_partitioning").customizeDocumentCommand(document, command);
                for (to = 1; to < command.text.length() && Character.isWhitespace(command.text.charAt(to)); ++to) {
                }
                indent = command.text.substring(1, to);
            } else if (!this.fIsTabAction && partition.getOffset() == offset && type.equals("__java_singleline_comment")) {
                int slashes;
                for (slashes = 2; slashes < document.getLength() - 1 && document.get(offset + slashes, 2).equals("//"); slashes += 2) {
                }
                wsStart = offset + slashes;
                StringBuffer computed = indenter.computeIndentation(offset);
                int tabSize = JavaPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
                while (slashes > 0 && computed.length() > 0) {
                    char c = computed.charAt(0);
                    if (c == '\t') {
                        if (slashes <= tabSize) break;
                        slashes -= tabSize;
                    } else {
                        if (c != ' ') break;
                        --slashes;
                    }
                    computed.deleteCharAt(0);
                }
                indent = document.get(offset, wsStart - offset) + computed;
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (this.fIsTabAction && caret == end && this.whiteSpaceLength(currentIndent) >= this.whiteSpaceLength(indent)) {
            String tab = this.getTabEquivalent();
            document.replace(caret, 0, tab);
            this.fCaretOffset = caret + tab.length();
            return true;
        }
        this.fCaretOffset = caret >= offset && caret <= end ? offset + indent.length() : -1;
        if (!indent.equals(currentIndent)) {
            SmartBackspaceManager manager;
            ITextEditor editor;
            String deletedText = document.get(offset, length);
            document.replace(offset, length, indent);
            if (this.fIsTabAction && indent.length() > currentIndent.length() && JavaPlugin.getDefault().getPreferenceStore().getBoolean("smart_backspace") && (editor = this.getTextEditor()) != null && (manager = (SmartBackspaceManager)editor.getAdapter(class$org$eclipse$jdt$internal$ui$text$SmartBackspaceManager == null ? (class$org$eclipse$jdt$internal$ui$text$SmartBackspaceManager = IndentAction.class$("org.eclipse.jdt.internal.ui.text.SmartBackspaceManager")) : class$org$eclipse$jdt$internal$ui$text$SmartBackspaceManager)) != null) {
                try {
                    ReplaceEdit smart = new ReplaceEdit(offset, indent.length(), deletedText);
                    SmartBackspaceManager.UndoSpec spec = new SmartBackspaceManager.UndoSpec(offset + indent.length(), (IRegion)new Region(caret, 0), new TextEdit[]{smart}, 2, null);
                    manager.register(spec);
                }
                catch (MalformedTreeException e) {
                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal smart backspace action", (Throwable)e));
                }
            }
            return true;
        }
        return false;
    }

    private int whiteSpaceLength(String indent) {
        if (indent == null) {
            return 0;
        }
        int size = 0;
        int l = indent.length();
        int tabSize = JavaPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
        for (int i = 0; i < l; ++i) {
            size += indent.charAt(i) == '\t' ? tabSize : 1;
        }
        return size;
    }

    private String getTabEquivalent() {
        String tab;
        if (JavaPlugin.getDefault().getPreferenceStore().getBoolean("spacesForTabs")) {
            int size = JavaCore.getPlugin().getPluginPreferences().getInt("org.eclipse.jdt.core.formatter.tabulation.size");
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                buf.append(' ');
            }
            tab = buf.toString();
        } else {
            tab = "\t";
        }
        return tab;
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            if (this.fIsTabAction) {
                this.setEnabled(this.canModifyEditor() && this.isSmartMode() && this.isValidSelection());
            } else {
                this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
            }
        }
    }

    private boolean isValidSelection() {
        ITextSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        int offset = selection.getOffset();
        int length = selection.getLength();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            IRegion firstLine = document.getLineInformationOfOffset(offset);
            int lineOffset = firstLine.getOffset();
            if (length == 0) {
                return document.get(lineOffset, offset - lineOffset).trim().length() == 0;
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private boolean isSmartMode() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension3) {
            return ((ITextEditorExtension3)editor).getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

