/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingMap;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.themes.ITheme;

public class Theme
implements ITheme {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle((class$org$eclipse$ui$internal$themes$Theme == null ? (class$org$eclipse$ui$internal$themes$Theme = Theme.class$("org.eclipse.ui.internal.themes.Theme")) : class$org$eclipse$ui$internal$themes$Theme).getName());
    private CascadingColorRegistry themeColorRegistry;
    private CascadingFontRegistry themeFontRegistry;
    private IThemeDescriptor descriptor;
    private IPropertyChangeListener themeListener;
    private CascadingMap dataMap;
    private ListenerList propertyChangeListeners = new ListenerList();
    private ThemeRegistry themeRegistry = (ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry();
    private IPropertyChangeListener propertyListener;
    static /* synthetic */ Class class$org$eclipse$ui$internal$themes$Theme;

    public Theme(IThemeDescriptor descriptor) {
        this.descriptor = descriptor;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (descriptor != null) {
            FontDefinition[] fontDefinitions;
            ColorDefinition[] definitions = this.descriptor.getColors();
            ITheme theme = workbench.getThemeManager().getTheme("org.eclipse.ui.defaultTheme");
            if (definitions.length > 0) {
                this.themeColorRegistry = new CascadingColorRegistry(theme.getColorRegistry());
                ThemeElementHelper.populateRegistry((ITheme)this, definitions, workbench.getPreferenceStore());
            }
            if ((fontDefinitions = this.descriptor.getFonts()).length > 0) {
                this.themeFontRegistry = new CascadingFontRegistry(theme.getFontRegistry());
                ThemeElementHelper.populateRegistry((ITheme)this, fontDefinitions, workbench.getPreferenceStore());
            }
            this.dataMap = new CascadingMap(((ThemeRegistry)WorkbenchPlugin.getDefault().getThemeRegistry()).getData(), descriptor.getData());
        }
        this.getColorRegistry().addListener(this.getCascadeListener());
        this.getFontRegistry().addListener(this.getCascadeListener());
        workbench.getPreferenceStore().addPropertyChangeListener(this.getPropertyListener());
    }

    private IPropertyChangeListener getPropertyListener() {
        if (this.propertyListener == null) {
            this.propertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String[] split = ThemeElementHelper.splitPropertyName(Theme.this, event.getProperty());
                    String key = split[1];
                    String theme = split[0];
                    if (key.equals("CURRENT_THEME_ID")) {
                        return;
                    }
                    try {
                        if (Theme.this.themeColorRegistry != null) {
                            if (Theme.this.getColorRegistry().hasValueFor(key) && theme != null && theme.equals(Theme.this.getId())) {
                                RGB rgb = StringConverter.asRGB((String)((String)event.getNewValue()));
                                Theme.this.getColorRegistry().put(key, rgb);
                                this.processDefaultsTo(key, rgb);
                                return;
                            }
                        } else if (Theme.this.getColorRegistry().hasValueFor(key) && theme == null) {
                            RGB rgb = StringConverter.asRGB((String)((String)event.getNewValue()));
                            Theme.this.getColorRegistry().put(key, rgb);
                            this.processDefaultsTo(key, rgb);
                            return;
                        }
                        if (Theme.this.themeFontRegistry != null) {
                            if (Theme.this.getFontRegistry().hasValueFor(key) && theme != null && theme.equals(Theme.this.getId())) {
                                FontData[] data = PreferenceConverter.basicGetFontData((String)((String)event.getNewValue()));
                                Theme.this.getFontRegistry().put(key, data);
                                this.processDefaultsTo(key, data);
                                return;
                            }
                        } else if (Theme.this.getFontRegistry().hasValueFor(key) && theme == null) {
                            FontData[] data = PreferenceConverter.basicGetFontData((String)((String)event.getNewValue()));
                            Theme.this.getFontRegistry().put(key, data);
                            this.processDefaultsTo(key, data);
                            return;
                        }
                    }
                    catch (DataFormatException e) {
                        // empty catch block
                    }
                }

                private void processDefaultsTo(String key, FontData[] fd) {
                    FontDefinition[] defs = WorkbenchPlugin.getDefault().getThemeRegistry().getFontsFor(Theme.this.getId());
                    for (int i = 0; i < defs.length; ++i) {
                        IPreferenceStore store;
                        String defaultsTo = defs[i].getDefaultsTo();
                        if (defaultsTo == null || !defaultsTo.equals(key) || !(store = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(ThemeElementHelper.createPreferenceKey(Theme.this, defs[i].getId()))) continue;
                        Theme.this.getFontRegistry().put(defs[i].getId(), fd);
                        this.processDefaultsTo(defs[i].getId(), fd);
                    }
                }

                private void processDefaultsTo(String key, RGB rgb) {
                    ColorDefinition[] defs = WorkbenchPlugin.getDefault().getThemeRegistry().getColorsFor(Theme.this.getId());
                    for (int i = 0; i < defs.length; ++i) {
                        IPreferenceStore store;
                        String defaultsTo = defs[i].getDefaultsTo();
                        if (defaultsTo == null || !defaultsTo.equals(key) || !(store = WorkbenchPlugin.getDefault().getPreferenceStore()).isDefault(ThemeElementHelper.createPreferenceKey(Theme.this, defs[i].getId()))) continue;
                        Theme.this.getColorRegistry().put(defs[i].getId(), rgb);
                        this.processDefaultsTo(defs[i].getId(), rgb);
                    }
                }
            };
        }
        return this.propertyListener;
    }

    private IPropertyChangeListener getCascadeListener() {
        if (this.themeListener == null) {
            this.themeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    Theme.this.firePropertyChange(event);
                }
            };
        }
        return this.themeListener;
    }

    public ColorRegistry getColorRegistry() {
        if (this.themeColorRegistry != null) {
            return this.themeColorRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeColorRegistry();
    }

    public FontRegistry getFontRegistry() {
        if (this.themeFontRegistry != null) {
            return this.themeFontRegistry;
        }
        return WorkbenchThemeManager.getInstance().getDefaultThemeFontRegistry();
    }

    public void dispose() {
        if (this.themeColorRegistry != null) {
            this.themeColorRegistry.removeListener(this.themeListener);
            this.themeColorRegistry.dispose();
        }
        if (this.themeFontRegistry != null) {
            this.themeFontRegistry.removeListener(this.themeListener);
            this.themeFontRegistry.dispose();
        }
        PlatformUI.getWorkbench().getPreferenceStore().removePropertyChangeListener(this.getPropertyListener());
    }

    public String getId() {
        return this.descriptor == null ? "org.eclipse.ui.defaultTheme" : this.descriptor.getId();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
        }
    }

    public String getLabel() {
        return this.descriptor == null ? RESOURCE_BUNDLE.getString("DefaultTheme.label") : this.descriptor.getLabel();
    }

    public String getString(String key) {
        if (this.dataMap != null) {
            return (String)this.dataMap.get(key);
        }
        return (String)this.themeRegistry.getData().get(key);
    }

    public Set keySet() {
        if (this.dataMap != null) {
            return this.dataMap.keySet();
        }
        return this.themeRegistry.getData().keySet();
    }

    public int getInt(String key) {
        String string = this.getString(key);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean getBoolean(String key) {
        String string = this.getString(key);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(this.getString(key));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

