/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class ErrorReportValve
extends ValveBase {
    private int debug = 0;
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        ServletRequest sreq = (ServletRequest)request;
        Throwable throwable = (Throwable)sreq.getAttribute("javax.servlet.error.exception");
        ServletResponse sresp = (ServletResponse)response;
        if (sresp.isCommitted()) {
            return;
        }
        if (throwable != null) {
            response.setError();
            try {
                sresp.reset();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            ServletResponse sresponse = (ServletResponse)response;
            if (sresponse instanceof HttpServletResponse) {
                ((HttpServletResponse)sresponse).sendError(500);
            }
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable tt) {
            tt.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ErrorReportValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void report(Request request, Response response, Throwable throwable) throws IOException {
        block17: {
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse hresponse = (HttpResponse)response;
            if (!(response instanceof HttpServletResponse)) {
                return;
            }
            HttpServletResponse hres = (HttpServletResponse)response;
            int statusCode = hresponse.getStatus();
            String message = RequestUtil.filter(hresponse.getMessage());
            if (message == null) {
                message = "";
            }
            if (statusCode < 400) {
                return;
            }
            Throwable rootCause = null;
            if (throwable != null && throwable instanceof ServletException) {
                rootCause = ((ServletException)throwable).getRootCause();
            }
            String report = null;
            try {
                report = sm.getString("http." + statusCode, message);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (report == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html><head><title>");
            sb.append(ServerInfo.getServerInfo()).append(" - ");
            sb.append(sm.getString("errorReportValve.errorReport"));
            sb.append("</title>");
            sb.append("<STYLE><!--");
            sb.append("H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} ");
            sb.append("H3{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} ");
            sb.append("BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} ");
            sb.append("B{color : white;background-color : #0086b2;} ");
            sb.append("HR{color : #0086b2;} ");
            sb.append("--></STYLE> ");
            sb.append("</head><body>");
            sb.append("<h1>");
            sb.append(sm.getString("errorReportValve.statusHeader", "" + statusCode, message)).append("</h1>");
            sb.append("<HR size=\"1\" noshade>");
            sb.append("<p><b>type</b> ");
            if (throwable != null) {
                sb.append(sm.getString("errorReportValve.exceptionReport"));
            } else {
                sb.append(sm.getString("errorReportValve.statusReport"));
            }
            sb.append("</p>");
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.message"));
            sb.append("</b> <u>");
            sb.append(message).append("</u></p>");
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.description"));
            sb.append("</b> <u>");
            sb.append(report);
            sb.append("</u></p>");
            if (throwable != null) {
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.exception"));
                sb.append("</b> <pre>");
                sb.append(RequestUtil.filter(stackTrace.toString()));
                sb.append("</pre></p>");
                if (rootCause != null) {
                    stackTrace = new StringWriter();
                    rootCause.printStackTrace(new PrintWriter(stackTrace));
                    sb.append("<p><b>");
                    sb.append(sm.getString("errorReportValve.rootCause"));
                    sb.append("</b> <pre>");
                    sb.append(RequestUtil.filter(stackTrace.toString()));
                    sb.append("</pre></p>");
                }
            }
            sb.append("<HR size=\"1\" noshade>");
            sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
            sb.append("</body></html>");
            try {
                PrintWriter writer;
                block18: {
                    writer = response.getReporter();
                    if (writer == null) break block17;
                    Locale locale = Locale.getDefault();
                    try {
                        hres.setContentType("text/html");
                        hres.setLocale(locale);
                    }
                    catch (Throwable t) {
                        if (this.debug < 1) break block18;
                        this.log("status.setContentType", t);
                    }
                }
                ((Writer)writer).write(sb.toString());
                ((Writer)writer).flush();
            }
            catch (IOException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

