/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Status;

public class ContentTypeBuilder
implements IRegistryChangeListener {
    public static final String PT_CONTENTTYPES = "contentTypes";
    private ContentTypeManager catalog;
    private Map orphanAssociations = new HashMap();

    public ContentTypeBuilder(ContentTypeManager catalog) {
        this.catalog = catalog;
    }

    private void addFileAssociation(IConfigurationElement fileAssociationElement, ContentType target) {
        String[] fileNames = ContentType.parseItems(fileAssociationElement.getAttributeAsIs("file-names"));
        for (int i = 0; i < fileNames.length; ++i) {
            target.internalAddFileSpec(fileNames[i], 5);
        }
        String[] fileExtensions = ContentType.parseItems(fileAssociationElement.getAttributeAsIs("file-extensions"));
        for (int i = 0; i < fileExtensions.length; ++i) {
            target.internalAddFileSpec(fileExtensions[i], 9);
        }
    }

    public void buildContentTypes() {
        int i;
        IConfigurationElement[] allContentTypeCEs = this.getConfigurationElements();
        for (i = 0; i < allContentTypeCEs.length; ++i) {
            if (!allContentTypeCEs[i].getName().equals("content-type")) continue;
            this.registerContentType(allContentTypeCEs[i]);
        }
        for (i = 0; i < allContentTypeCEs.length; ++i) {
            if (!allContentTypeCEs[i].getName().equals("file-association")) continue;
            this.registerFileAssociation(allContentTypeCEs[i]);
        }
        this.validateCatalog();
    }

    public ContentType createContentType(IConfigurationElement contentTypeCE) {
        String simpleId = contentTypeCE.getAttributeAsIs("id");
        byte priority = this.parsePriority(contentTypeCE.getAttributeAsIs("priority"));
        String namespace = contentTypeCE.getDeclaringExtension().getNamespace();
        String name = contentTypeCE.getAttribute("name");
        String[] fileNames = ContentType.parseItems(contentTypeCE.getAttributeAsIs("file-names"));
        String[] fileExtensions = ContentType.parseItems(contentTypeCE.getAttributeAsIs("file-extensions"));
        String baseTypeId = ContentTypeBuilder.getUniqueId(namespace, contentTypeCE.getAttributeAsIs("base-type"));
        String defaultCharset = contentTypeCE.getAttributeAsIs("default-charset");
        return ContentType.createContentType(this.catalog, namespace, simpleId, name, priority, fileExtensions, fileNames, baseTypeId, defaultCharset, contentTypeCE);
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
        IExtensionPoint contentTypesXP = registry.getExtensionPoint("org.eclipse.core.runtime", PT_CONTENTTYPES);
        IConfigurationElement[] allContentTypeCEs = contentTypesXP.getConfigurationElements();
        return allContentTypeCEs;
    }

    private byte parsePriority(String priority) {
        if (priority == null) {
            return 0;
        }
        if (priority.equals("high")) {
            return 1;
        }
        if (priority.equals("low")) {
            return -1;
        }
        if (!priority.equals("normal")) {
            return 0;
        }
        return 0;
    }

    protected void registerContentType(IConfigurationElement contentTypeCE) {
        ContentType contentType = this.createContentType(contentTypeCE);
        if (!this.isComplete(contentType)) {
            return;
        }
        this.catalog.addContentType(contentType);
        Set orphans = (Set)this.orphanAssociations.remove(contentType.getId());
        if (orphans == null) {
            return;
        }
        Iterator iter = orphans.iterator();
        while (iter.hasNext()) {
            this.addFileAssociation((IConfigurationElement)iter.next(), contentType);
        }
    }

    private boolean isComplete(ContentType contentType) {
        String message = null;
        if (contentType.getSimpleId() == null) {
            message = Policy.bind("content.missingIdentifier", contentType.getId());
        } else if (contentType.getName() == null) {
            message = Policy.bind("content.missingName", contentType.getId());
        }
        if (message == null) {
            return true;
        }
        Status status = new Status(4, "org.eclipse.core.runtime", 0, message, null);
        InternalPlatform.getDefault().log(status);
        return false;
    }

    private void registerFileAssociation(IConfigurationElement fileAssociationElement) {
        String contentTypeId = ContentTypeBuilder.getUniqueId(fileAssociationElement.getDeclaringExtension().getNamespace(), fileAssociationElement.getAttribute("content-type"));
        ContentType target = this.catalog.internalGetContentType(contentTypeId);
        if (target == null) {
            HashSet<IConfigurationElement> orphans = (HashSet<IConfigurationElement>)this.orphanAssociations.get(contentTypeId);
            if (orphans == null) {
                orphans = new HashSet<IConfigurationElement>(3);
                this.orphanAssociations.put(contentTypeId, orphans);
            }
            orphans.add(fileAssociationElement);
            return;
        }
        this.addFileAssociation(fileAssociationElement, target);
    }

    private static String getUniqueId(String namespace, String baseTypeId) {
        if (baseTypeId == null) {
            return null;
        }
        int separatorPosition = baseTypeId.lastIndexOf(46);
        if (separatorPosition == -1) {
            baseTypeId = namespace + '.' + baseTypeId;
        }
        return baseTypeId;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.core.runtime", PT_CONTENTTYPES);
        for (int i = 0; i < deltas.length; ++i) {
            IConfigurationElement[] configElements = deltas[i].getExtension().getConfigurationElements();
            if (deltas[i].getKind() != 1) continue;
            int j = 0;
            while (i < configElements.length) {
                if (configElements[j].getName().equals("content-type")) {
                    this.registerContentType(configElements[j]);
                }
                ++i;
            }
            j = 0;
            while (i < configElements.length) {
                if (configElements[j].getName().equals("file-association")) {
                    this.registerFileAssociation(configElements[j]);
                }
                ++i;
            }
        }
        this.validateCatalog();
    }

    public void startup() {
        InternalPlatform.getDefault().getRegistry().addRegistryChangeListener(this, "org.eclipse.core.runtime");
    }

    protected void validateCatalog() {
        this.catalog.reorganize();
    }
}

