/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
extends SingleSourcePackage
implements ExportedPackage {
    String specVersion;

    public ExportedPackageImpl(PackageSpecification packageSpec, BundleLoaderProxy supplier) {
        super(packageSpec.getName(), supplier);
        Version version = packageSpec.getActualVersion();
        if (version != null) {
            this.specVersion = version.toString();
        }
    }

    public String getName() {
        return this.getId();
    }

    public Bundle getExportingBundle() {
        if (this.supplier.isStale()) {
            return null;
        }
        return this.supplier.getBundleHost();
    }

    public Bundle[] getImportingBundles() {
        if (this.supplier.isStale()) {
            return null;
        }
        AbstractBundle[] dependentBundles = this.supplier.getDependentBundles();
        ArrayList<AbstractBundle> importingBundles = new ArrayList<AbstractBundle>();
        importingBundles.add(this.supplier.getBundleHost());
        for (int i = 0; i < dependentBundles.length; ++i) {
            AbstractBundle bundle = dependentBundles[i];
            BundleLoader bundleLoader = bundle.getBundleLoader();
            if (bundleLoader.importedPackages == null || bundleLoader.importedPackages.getByKey(this.getId()) == null) continue;
            importingBundles.add(bundle);
        }
        Bundle[] result = new AbstractBundle[importingBundles.size()];
        importingBundles.toArray(result);
        return result;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public boolean isRemovalPending() {
        AbstractBundle bundle = this.supplier.getBundleHost();
        return bundle.framework.packageAdmin.removalPending.contains(this.supplier);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getId());
        if (this.specVersion != null) {
            result.append("; ").append("specification-version");
            result.append("=\"").append(this.specVersion).append("\"");
        }
        return result.toString();
    }
}

