/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;

public abstract class AbstractNewPluginTemplateWizard
extends Wizard
implements IPluginContentWizard {
    private static final String KEY_WTITLE = "PluginCodeGeneratorWizard.title";
    private IFieldData data;

    public AbstractNewPluginTemplateWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEXPRJ_WIZ);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IFieldData data) {
        this.data = data;
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public IFieldData getData() {
        return this.data;
    }

    protected abstract void addAdditionalPages();

    public final void addPages() {
        this.addAdditionalPages();
    }

    public boolean performFinish() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish(IProject project, IPluginModelBase model, IProgressMonitor monitor) {
        try {
            ITemplateSection[] sections = this.getTemplateSections();
            monitor.beginTask("", sections.length);
            for (int i = 0; i < sections.length; ++i) {
                sections[i].execute(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public abstract ITemplateSection[] getTemplateSections();

    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        ITemplateSection[] sections = this.getTemplateSections();
        for (int i = 0; i < sections.length; ++i) {
            IPluginReference[] refs = sections[i].getDependencies(schemaVersion);
            for (int j = 0; j < refs.length; ++j) {
                if (result.contains(refs[j])) continue;
                result.add(refs[j]);
            }
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    public String[] getNewFiles() {
        ArrayList<String> result = new ArrayList<String>();
        ITemplateSection[] sections = this.getTemplateSections();
        for (int i = 0; i < sections.length; ++i) {
            String[] newFiles = sections[i].getNewFiles();
            for (int j = 0; j < newFiles.length; ++j) {
                if (result.contains(newFiles[j])) continue;
                result.add(newFiles[j]);
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

