/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class JUnitTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private Vector formatters;
    private TestResult res;
    private static boolean filtertrace = true;
    private boolean showOutput;
    private Permissions perm;
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "org.apache.tools.ant."};
    private boolean haltOnError;
    private boolean haltOnFailure;
    private Test suite;
    private Exception exception;
    private int retCode;
    private JUnitTest junitTest;
    private PrintStream systemError;
    private PrintStream systemOut;
    private boolean forked;
    private static boolean multipleTests = false;
    private static Vector fromCmdLine = new Vector();

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure) {
        this(test, haltOnError, filtertrace, haltOnFailure, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, null);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, ClassLoader loader) {
        block5: {
            this.formatters = new Vector();
            this.showOutput = false;
            this.perm = null;
            this.haltOnError = false;
            this.haltOnFailure = false;
            this.suite = null;
            this.retCode = 0;
            this.forked = false;
            JUnitTestRunner.filtertrace = filtertrace;
            this.junitTest = test;
            this.haltOnError = haltOnError;
            this.haltOnFailure = haltOnFailure;
            this.showOutput = showOutput;
            try {
                Class<?> testClass = null;
                testClass = loader == null ? Class.forName(test.getName()) : Class.forName(test.getName(), true, loader);
                Method suiteMethod = null;
                try {
                    suiteMethod = testClass.getMethod("suite", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (suiteMethod != null) {
                    this.suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                    break block5;
                }
                this.suite = new TestSuite(testClass);
            }
            catch (Exception e) {
                this.retCode = 2;
                this.exception = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.res = new TestResult();
        this.res.addListener((TestListener)this);
        int i = 0;
        while (i < this.formatters.size()) {
            this.res.addListener((TestListener)this.formatters.elementAt(i));
            ++i;
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.exception != null) {
            int i2 = 0;
            while (i2 < this.formatters.size()) {
                ((TestListener)this.formatters.elementAt(i2)).addError(null, (Throwable)this.exception);
                ++i2;
            }
            this.junitTest.setCounts(1L, 0L, 1L);
            this.junitTest.setRunTime(0L);
        } else {
            ByteArrayOutputStream errStrm = new ByteArrayOutputStream();
            this.systemError = new PrintStream(errStrm);
            ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
            this.systemOut = new PrintStream(outStrm);
            PrintStream savedOut = null;
            PrintStream savedErr = null;
            if (this.forked) {
                savedOut = System.out;
                savedErr = System.err;
                if (!this.showOutput) {
                    System.setOut(this.systemOut);
                    System.setErr(this.systemError);
                } else {
                    System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)savedOut, (OutputStream)this.systemOut)));
                    System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)savedErr, (OutputStream)this.systemError)));
                }
                this.perm = null;
            } else if (this.perm != null) {
                this.perm.setSecurityManager();
            }
            try {
                this.suite.run(this.res);
            }
            finally {
                if (this.perm != null) {
                    this.perm.restoreSecurityManager();
                }
                if (savedOut != null) {
                    System.setOut(savedOut);
                }
                if (savedErr != null) {
                    System.setErr(savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
                this.junitTest.setRunTime(System.currentTimeMillis() - start);
            }
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    protected void handleOutput(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        return -1;
    }

    protected void handleErrorOutput(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    protected void handleFlush(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    protected void handleErrorFlush(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    private void sendOutAndErr(String out, String err) {
        int i = 0;
        while (i < this.formatters.size()) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
            ++i;
        }
    }

    private void fireStartTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.junitTest);
            ++i;
        }
    }

    private void fireEndTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.junitTest);
            ++i;
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    public static void main(String[] args) throws IOException {
        boolean haltError = false;
        boolean haltFail = false;
        boolean stackfilter = true;
        Properties props = new Properties();
        boolean showOut = false;
        if (args.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        if (args[0].startsWith("testsfile=")) {
            multipleTests = true;
            args[0] = args[0].substring(10);
        }
        int i = 1;
        while (i < args.length) {
            if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean((String)args[i].substring(12));
            } else if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean((String)args[i].substring(14));
            } else if (args[i].startsWith("filtertrace=")) {
                stackfilter = Project.toBoolean((String)args[i].substring(12));
            } else if (args[i].startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(args[i].substring(10));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    System.exit(2);
                }
            } else if (args[i].startsWith("propsfile=")) {
                FileInputStream in = new FileInputStream(args[i].substring(10));
                props.load(in);
                in.close();
            } else if (args[i].startsWith("showoutput=")) {
                showOut = Project.toBoolean((String)args[i].substring(11));
            }
            ++i;
        }
        Properties p = System.getProperties();
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        int returnCode = 0;
        if (multipleTests) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(args[0]));
                int code = 0;
                boolean errorOccured = false;
                boolean failureOccured = false;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, ",");
                    String testCaseName = st.nextToken();
                    JUnitTest t = new JUnitTest(testCaseName);
                    t.setTodir(new File(st.nextToken()));
                    t.setOutfile(st.nextToken());
                    code = JUnitTestRunner.launch(t, haltError, stackfilter, haltFail, showOut, props);
                    errorOccured = code == 2;
                    boolean bl = failureOccured = code != 0;
                    if (!errorOccured && !failureOccured) continue;
                    if (errorOccured && haltError || failureOccured && haltFail) {
                        System.exit(code);
                        continue;
                    }
                    if (code > returnCode) {
                        returnCode = code;
                    }
                    System.out.println("TEST " + t.getName() + " FAILED");
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            returnCode = JUnitTestRunner.launch(new JUnitTest(args[0]), haltError, stackfilter, haltFail, showOut, props);
        }
        System.exit(returnCode);
    }

    private static void transferFormatters(JUnitTestRunner runner, JUnitTest test) {
        int i = 0;
        while (i < fromCmdLine.size()) {
            FormatterElement fe = (FormatterElement)fromCmdLine.elementAt(i);
            if (multipleTests && fe.getUseFile()) {
                File destFile = new File(test.getTodir(), test.getOutfile() + fe.getExtension());
                fe.setOutfile(destFile);
            }
            runner.addFormatter(fe.createFormatter());
            ++i;
        }
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        int pos = line.indexOf(44);
        if (pos == -1) {
            fe.setClassname(line);
            fe.setUseFile(false);
        } else {
            fe.setClassname(line.substring(0, pos));
            fe.setUseFile(true);
            if (!multipleTests) {
                fe.setOutfile(new File(line.substring(pos + 1)));
            }
        }
        fromCmdLine.addElement(fe);
    }

    public static String getFilteredTrace(Throwable t) {
        String trace = StringUtils.getStackTrace((Throwable)t);
        return JUnitTestRunner.filterStack(trace);
    }

    /*
     * WARNING - void declaration
     */
    public static String filterStack(String stack) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                void var5_5;
                if (JUnitTestRunner.filterLine((String)var5_5)) continue;
                pw.println((String)var5_5);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        int i = 0;
        while (i < DEFAULT_TRACE_FILTERS.length) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int launch(JUnitTest t, boolean haltError, boolean stackfilter, boolean haltFail, boolean showOut, Properties props) {
        t.setProperties(props);
        JUnitTestRunner runner = new JUnitTestRunner(t, haltError, stackfilter, haltFail, showOut);
        runner.forked = true;
        JUnitTestRunner.transferFormatters(runner, t);
        runner.run();
        return runner.getRetCode();
    }
}

