/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.registry.Sorter;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";

    RegistryReader() {
    }

    String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    private void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, buf.toString(), null);
        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
    }

    void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    private void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    private IExtension[] orderExtensions(IExtension[] extensions) {
        Sorter sorter = new Sorter(){

            public boolean compare(Object extension1, Object extension2) {
                String s1 = ((IExtension)extension1).getNamespace().toUpperCase();
                String s2 = ((IExtension)extension2).getNamespace().toUpperCase();
                return s2.compareTo(s1) > 0;
            }
        };
        Object[] sorted = sorter.sort(extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    abstract boolean readElement(IConfigurationElement var1);

    void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    private void readElements(IConfigurationElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (this.readElement(elements[i])) continue;
            this.logUnknownElement(elements[i]);
        }
    }

    private void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            for (int i = 0; i < extensions.length; ++i) {
                this.readExtension(extensions[i]);
            }
        }
    }
}

