/*	$NetBSD: vt220iso8x8.h,v 1.2 2023/09/21 09:31:50 msaitoh Exp $	*/

/*
 *  Copyright (c) 1992, 1993, 1994 Hellmuth Michaelis and Joerg Wunsch
 *  
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. All advertising materials mentioning features or use of this software
 *     must display the following acknowledgement:
 * 	This product includes software developed by
 *	Hellmuth Michaelis and Joerg Wunsch
 *  4. The name authors may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Translated into compiler and human readable for the Atari-TT port of
 * NetBSD by Leo Weppelman.
 *
 * Reorganized and edited some chars to fit the iso-8859-1 fontset
 * by Thomas Gerner
 *
 * Translated into wsfont format from sys/arch/atari/dev/font_8x8.c rev 1.4
 * by Izumi Tsutsui.
 */

static u_char vt220iso8x8_data[];

static struct wsdisplay_font vt220iso8x8 = {
	"vt220iso8x8",			/* typeface name */
	' ',				/* firstchar */
	0xff - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	8,				/* width */
	8,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	vt220iso8x8_data		/* data */
};

static u_char vt220iso8x8_data[] = {
#if 0
	/* 0x00 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x01 */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x7e,	/* .******. */
	0xff,	/* ******** */
	0xff,	/* ******** */
	0x7e,	/* .******. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */

	/* 0x02 */
	0x5a,	/* .*.**.*. */
	0x99,	/* *..**..* */
	0x42,	/* .*....*. */
	0x99,	/* *..**..* */
	0x5a,	/* .*.**.*. */
	0x81,	/* *......* */
	0x5a,	/* .*.**.*. */
	0x99,	/* *..**..* */

	/* 0x03 */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x44,	/* .*...*.. */
	0x3e,	/* ..*****. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */

	/* 0x04 */
	0x7c,	/* .*****.. */
	0x40,	/* .*...... */
	0x78,	/* .****... */
	0x40,	/* .*...... */
	0x3e,	/* ..*****. */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x20,	/* ..*..... */

	/* 0x05 */
	0x3c,	/* ..****.. */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x3c,	/* ..****.. */
	0x3c,	/* ..****.. */
	0x22,	/* ..*...*. */
	0x3c,	/* ..****.. */
	0x26,	/* ..*..**. */

	/* 0x06 */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x7c,	/* .*****.. */
	0x3e,	/* ..*****. */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x20,	/* ..*..... */

	/* 0x07 */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x08 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x09 */
	0x64,	/* .**..*.. */
	0x54,	/* .*.*.*.. */
	0x4c,	/* .*..**.. */
	0x44,	/* .*...*.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3e,	/* ..*****. */

	/* 0x0A */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x3e,	/* ..*****. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */

	/* 0x0B */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0xf8,	/* *****... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x0C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x0D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x1f,	/* ...***** */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x0E */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x1f,	/* ...***** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x0F */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0xff,	/* ******** */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x10 */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x11 */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x12 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x13 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x14 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */

	/* 0x15 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x1f,	/* ...***** */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x16 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0xf8,	/* *****... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x17 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x18 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x19 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0x1A */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0xfe,	/* *******. */

	/* 0x1B */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0xfe,	/* *******. */

	/* 0x1C */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */

	/* 0x1D */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x7e,	/* .******. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x7e,	/* .******. */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */

	/* 0x1E */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x64,	/* .**..*.. */
	0xf0,	/* ****.... */
	0x60,	/* .**..... */
	0xe6,	/* ***..**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x1F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
#endif

	/* 0x20 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x21 */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x22 */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x23 */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0xfe,	/* *******. */
	0x6c,	/* .**.**.. */
	0xfe,	/* *******. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */

	/* 0x24 */
	0x30,	/* ..**.... */
	0x7c,	/* .*****.. */
	0xc0,	/* **...... */
	0x7c,	/* .*****.. */
	0x06,	/* .....**. */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x25 */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0xcc,	/* **..**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x66,	/* .**..**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x26 */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x76,	/* .***.**. */
	0xdc,	/* **.***.. */
	0xce,	/* **..***. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */

	/* 0x27 */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0xc0,	/* **...... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x28 */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x29 */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x2A */
	0x00,	/* ........ */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0xfe,	/* *******. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2B */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */

	/* 0x2D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x2F */
	0x06,	/* .....**. */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0xc0,	/* **...... */
	0x80,	/* *....... */
	0x00,	/* ........ */

	/* 0x30 */
	0x7c,	/* .*****.. */
	0xce,	/* **..***. */
	0xde,	/* **.****. */
	0xf6,	/* ****.**. */
	0xe6,	/* ***..**. */
	0xc6,	/* **...**. */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */

	/* 0x31 */
	0x30,	/* ..**.... */
	0x70,	/* .***.... */
	0xb0,	/* *.**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x32 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0x0c,	/* ....**.. */
	0x38,	/* ..***... */
	0x60,	/* .**..... */
	0xc0,	/* **...... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x33 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0x0c,	/* ....**.. */
	0x38,	/* ..***... */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x34 */
	0x1c,	/* ...***.. */
	0x3c,	/* ..****.. */
	0x6c,	/* .**.**.. */
	0xcc,	/* **..**.. */
	0xfe,	/* *******. */
	0x0c,	/* ....**.. */
	0x1e,	/* ...****. */
	0x00,	/* ........ */

	/* 0x35 */
	0xfc,	/* ******.. */
	0xc0,	/* **...... */
	0xf8,	/* *****... */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x36 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xc0,	/* **...... */
	0xf8,	/* *****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x37 */
	0xfc,	/* ******.. */
	0xcc,	/* **..**.. */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x38 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x39 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x3A */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x3B */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */

	/* 0x3C */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0xc0,	/* **...... */
	0x60,	/* .**..... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x3D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x3E */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x06,	/* .....**. */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x3F */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x06,	/* .....**. */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x40 */
	0x7c,	/* .*****.. */
	0xc6,	/* **...**. */
	0xde,	/* **.****. */
	0xde,	/* **.****. */
	0xde,	/* **.****. */
	0xc0,	/* **...... */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0x41 */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0x42 */
	0xfc,	/* ******.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x7c,	/* .*****.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x43 */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0x44 */
	0xf8,	/* *****... */
	0x6c,	/* .**.**.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x6c,	/* .**.**.. */
	0xf8,	/* *****... */
	0x00,	/* ........ */

	/* 0x45 */
	0xfe,	/* *******. */
	0x62,	/* .**...*. */
	0x68,	/* .**.*... */
	0x78,	/* .****... */
	0x68,	/* .**.*... */
	0x62,	/* .**...*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */

	/* 0x46 */
	0xfe,	/* *******. */
	0x62,	/* .**...*. */
	0x68,	/* .**.*... */
	0x78,	/* .****... */
	0x68,	/* .**.*... */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */

	/* 0x47 */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0xce,	/* **..***. */
	0x66,	/* .**..**. */
	0x3e,	/* ..*****. */
	0x00,	/* ........ */

	/* 0x48 */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0x49 */
	0x78,	/* .****... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x4A */
	0x1e,	/* ...****. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x4B */
	0xe6,	/* ***..**. */
	0x6c,	/* .**.**.. */
	0x78,	/* .****... */
	0x70,	/* .***.... */
	0x78,	/* .****... */
	0x6c,	/* .**.**.. */
	0xe6,	/* ***..**. */
	0x00,	/* ........ */

	/* 0x4C */
	0xf0,	/* ****.... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x62,	/* .**...*. */
	0x66,	/* .**..**. */
	0xfe,	/* *******. */
	0x00,	/* ........ */

	/* 0x4D */
	0xc6,	/* **...**. */
	0xee,	/* ***.***. */
	0xfe,	/* *******. */
	0xd6,	/* **.*.**. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x4E */
	0xc6,	/* **...**. */
	0xe6,	/* ***..**. */
	0xf6,	/* ****.**. */
	0xde,	/* **.****. */
	0xce,	/* **..***. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x4F */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */

	/* 0x50 */
	0xfc,	/* ******.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x7c,	/* .*****.. */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */

	/* 0x51 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xdc,	/* **.***.. */
	0x78,	/* .****... */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */

	/* 0x52 */
	0xfc,	/* ******.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x7c,	/* .*****.. */
	0x6c,	/* .**.**.. */
	0x66,	/* .**..**. */
	0xe6,	/* ***..**. */
	0x00,	/* ........ */

	/* 0x53 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x54 */
	0xfc,	/* ******.. */
	0xb4,	/* *.**.*.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x55 */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x56 */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0x57 */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xd6,	/* **.*.**. */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x58 */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x59 */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x5A */
	0xfc,	/* ******.. */
	0xcc,	/* **..**.. */
	0x98,	/* *..**... */
	0x30,	/* ..**.... */
	0x64,	/* .**..*.. */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x5B */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x5C */
	0xc0,	/* **...... */
	0x60,	/* .**..... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x06,	/* .....**. */
	0x02,	/* ......*. */
	0x00,	/* ........ */

	/* 0x5D */
	0x78,	/* .****... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x5E */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x5F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */

	/* 0x60 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x61 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x76,	/* .***.**. */
	0x00,	/* ........ */

	/* 0x62 */
	0xe0,	/* ***..... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0x7c,	/* .*****.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x63 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xc0,	/* **...... */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x64 */
	0x1c,	/* ...***.. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0x65 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x66 */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x60,	/* .**..... */
	0xf8,	/* *****... */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */

	/* 0x67 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x76,	/* .***.**. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0xf8,	/* *****... */

	/* 0x68 */
	0xe0,	/* ***..... */
	0x60,	/* .**..... */
	0x6c,	/* .**.**.. */
	0x76,	/* .***.**. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0xe6,	/* ***..**. */
	0x00,	/* ........ */

	/* 0x69 */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x70,	/* .***.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x6A */
	0x0c,	/* ....**.. */
	0x00,	/* ........ */
	0x1c,	/* ...***.. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */

	/* 0x6B */
	0xe0,	/* ***..... */
	0x60,	/* .**..... */
	0x66,	/* .**..**. */
	0x6c,	/* .**.**.. */
	0x78,	/* .****... */
	0x6c,	/* .**.**.. */
	0xe6,	/* ***..**. */
	0x00,	/* ........ */

	/* 0x6C */
	0x70,	/* .***.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x6D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0xd6,	/* **.*.**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x6E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0x6F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0x70 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xdc,	/* **.***.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x7c,	/* .*****.. */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */

	/* 0x71 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x76,	/* .***.**. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0x1e,	/* ...****. */

	/* 0x72 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xdc,	/* **.***.. */
	0x76,	/* .***.**. */
	0x60,	/* .**..... */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */

	/* 0x73 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7c,	/* .*****.. */
	0xc0,	/* **...... */
	0x7c,	/* .*****.. */
	0x06,	/* .....**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x74 */
	0x10,	/* ...*.... */
	0x30,	/* ..**.... */
	0x7c,	/* .*****.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x36,	/* ..**.**. */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */

	/* 0x75 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x76,	/* .***.**. */
	0x00,	/* ........ */

	/* 0x76 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x7c,	/* .*****.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */

	/* 0x77 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0xd6,	/* **.*.**. */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */

	/* 0x78 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0x79 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0xf8,	/* *****... */

	/* 0x7A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x98,	/* *..**... */
	0x30,	/* ..**.... */
	0x64,	/* .**..*.. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0x7B */
	0x1c,	/* ...***.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xe0,	/* ***..... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */

	/* 0x7C */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x7D */
	0xe0,	/* ***..... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x1c,	/* ...***.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xe0,	/* ***..... */
	0x00,	/* ........ */

	/* 0x7E */
	0x76,	/* .***.**. */
	0xdc,	/* **.***.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x7F */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0x00,	/* ........ */

	/* 0x80 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x81 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x82 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x83 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x84 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x85 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x86 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x87 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x88 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x89 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8B */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x90 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x91 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x92 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x93 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x94 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x95 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x96 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x97 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x98 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x99 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9B */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA0 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA1 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xA2 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x7e,	/* .******. */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0x7e,	/* .******. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0xA3 */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x64,	/* .**..*.. */
	0xf0,	/* ****.... */
	0x60,	/* .**..... */
	0xe6,	/* ***..**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xA4 */
	0x00,	/* ........ */
	0xc3,	/* **....** */
	0xdb,	/* **.**.** */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0xdb,	/* **.**.** */
	0xc3,	/* **....** */

	/* 0xA5 */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */

	/* 0xA6 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */

	/* 0xA7 */
	0x7e,	/* .******. */
	0xc3,	/* **....** */
	0xfc,	/* ******.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x3f,	/* ..****** */
	0xc3,	/* **....** */
	0x7e,	/* .******. */

	/* 0xA8 */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA9 */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x9a,	/* *..**.*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0x9a,	/* *..**.*. */
	0x82,	/* *.....*. */
	0x7c,	/* .*****.. */

	/* 0xAA */
	0x3c,	/* ..****.. */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x3e,	/* ..*****. */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAB */
	0x00,	/* ........ */
	0x33,	/* ..**..** */
	0x66,	/* .**..**. */
	0xcc,	/* **..**.. */
	0x66,	/* .**..**. */
	0x33,	/* ..**..** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAC */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x0c,	/* ....**.. */
	0x0c,	/* ....**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAD */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAE */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0xba,	/* *.***.*. */
	0xaa,	/* *.*.*.*. */
	0xb2,	/* *.**..*. */
	0xaa,	/* *.*.*.*. */
	0x82,	/* *.....*. */
	0x7c,	/* .*****.. */

	/* 0xAF */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB0 */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB1 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0xfc,	/* ******.. */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xB2 */
	0x70,	/* .***.... */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB3 */
	0x70,	/* .***.... */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x18,	/* ...**... */
	0x70,	/* .***.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB4 */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB5 */
	0x00,	/* ........ */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x7c,	/* .*****.. */
	0x60,	/* .**..... */
	0xc0,	/* **...... */

	/* 0xB6 */
	0x7f,	/* .******* */
	0xdb,	/* **.**.** */
	0xdb,	/* **.**.** */
	0x7b,	/* .****.** */
	0x1b,	/* ...**.** */
	0x1b,	/* ...**.** */
	0x1b,	/* ...**.** */
	0x00,	/* ........ */

	/* 0xB7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB8 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x78,	/* .****... */

	/* 0xB9 */
	0x38,	/* ..***... */
	0x78,	/* .****... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBA */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBB */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0x66,	/* .**..**. */
	0x33,	/* ..**..** */
	0x66,	/* .**..**. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBC */
	0xc3,	/* **....** */
	0xc6,	/* **...**. */
	0xcc,	/* **..**.. */
	0xdb,	/* **.**.** */
	0x37,	/* ..**.*** */
	0x6f,	/* .**.**** */
	0xcf,	/* **..**** */
	0x03,	/* ......** */

	/* 0xBD */
	0xc3,	/* **....** */
	0xc6,	/* **...**. */
	0xcc,	/* **..**.. */
	0xde,	/* **.****. */
	0x33,	/* ..**..** */
	0x66,	/* .**..**. */
	0xcc,	/* **..**.. */
	0x0f,	/* ....**** */

	/* 0xBE */
	0xc3,	/* **....** */
	0x66,	/* .**..**. */
	0xcc,	/* **..**.. */
	0x5b,	/* .*.**.** */
	0xb7,	/* *.**.*** */
	0x6f,	/* .**.**** */
	0xcf,	/* **..**** */
	0x03,	/* ......** */

	/* 0xBF */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x60,	/* .**..... */
	0xc0,	/* **...... */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xC0 */
	0xe0,	/* ***..... */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0xC1 */
	0x0e,	/* ....***. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0xC2 */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0xC3 */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0xC4 */
	0xc6,	/* **...**. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0xc6,	/* **...**. */
	0xfe,	/* *******. */
	0xc6,	/* **...**. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */

	/* 0xC5 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0xC6 */
	0x3e,	/* ..*****. */
	0x6c,	/* .**.**.. */
	0xcc,	/* **..**.. */
	0xfe,	/* *******. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xce,	/* **..***. */
	0x00,	/* ........ */

	/* 0xC7 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xc0,	/* **...... */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x18,	/* ...**... */
	0x0c,	/* ....**.. */
	0x78,	/* .****... */

	/* 0xC8 */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xC9 */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xCA */
	0x78,	/* .****... */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xCB */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xCC */
	0x70,	/* .***.... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xCD */
	0x0e,	/* ....***. */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xCE */
	0x7e,	/* .******. */
	0x81,	/* *......* */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xCF */
	0x66,	/* .**..**. */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xD0 */
	0xfc,	/* ******.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0xf6,	/* ****.**. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */

	/* 0xD1 */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xec,	/* ***.**.. */
	0xfc,	/* ******.. */
	0xdc,	/* **.***.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0xD2 */
	0x70,	/* .***.... */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xD3 */
	0x0e,	/* ....***. */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xD4 */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xD5 */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xD6 */
	0xc3,	/* **....** */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x66,	/* .**..**. */
	0x3c,	/* ..****.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xD7 */
	0x00,	/* ........ */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */

	/* 0xD8 */
	0x00,	/* ........ */
	0x02,	/* ......*. */
	0x7c,	/* .*****.. */
	0xce,	/* **..***. */
	0xd6,	/* **.*.**. */
	0xe6,	/* ***..**. */
	0x7c,	/* .*****.. */
	0x80,	/* *....... */

	/* 0xD9 */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xDA */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xDB */
	0x78,	/* .****... */
	0x84,	/* *....*.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xDC */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xDD */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xDE */
	0xf0,	/* ****.... */
	0x60,	/* .**..... */
	0x78,	/* .****... */
	0x6c,	/* .**.**.. */
	0x78,	/* .****... */
	0x60,	/* .**..... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */

	/* 0xDF */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xf8,	/* *****... */
	0xcc,	/* **..**.. */
	0xf8,	/* *****... */
	0xc0,	/* **...... */
	0xc0,	/* **...... */

	/* 0xE0 */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xE1 */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xE2 */
	0x7e,	/* .******. */
	0xc3,	/* **....** */
	0x3c,	/* ..****.. */
	0x06,	/* .....**. */
	0x3e,	/* ..*****. */
	0x66,	/* .**..**. */
	0x3f,	/* ..****** */
	0x00,	/* ........ */

	/* 0xE3 */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xE4 */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xE5 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x7c,	/* .*****.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xE6 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7f,	/* .******* */
	0x0c,	/* ....**.. */
	0x7f,	/* .******* */
	0xcc,	/* **..**.. */
	0x7f,	/* .******* */
	0x00,	/* ........ */

	/* 0xE7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x0c,	/* ....**.. */
	0x38,	/* ..***... */

	/* 0xE8 */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xE9 */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xEA */
	0x7e,	/* .******. */
	0xc3,	/* **....** */
	0x3c,	/* ..****.. */
	0x66,	/* .**..**. */
	0x7e,	/* .******. */
	0x60,	/* .**..... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xEB */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xfc,	/* ******.. */
	0xc0,	/* **...... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xEC */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0x70,	/* .***.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xED */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x70,	/* .***.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xEE */
	0x7c,	/* .*****.. */
	0xc6,	/* **...**. */
	0x38,	/* ..***... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xEF */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x70,	/* .***.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF0 */
	0x00,	/* ........ */
	0x7c,	/* .*****.. */
	0x30,	/* ..**.... */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF1 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */

	/* 0xF2 */
	0x00,	/* ........ */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF3 */
	0x00,	/* ........ */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF4 */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF5 */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF6 */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x78,	/* .****... */
	0x00,	/* ........ */

	/* 0xF7 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */

	/* 0xF8 */
	0x02,	/* ......*. */
	0x3a,	/* ..***.*. */
	0x6c,	/* .**.**.. */
	0xd6,	/* **.*.**. */
	0xd6,	/* **.*.**. */
	0x6c,	/* .**.**.. */
	0xb8,	/* *.***... */
	0x80,	/* *....... */

	/* 0xF9 */
	0x00,	/* ........ */
	0xe0,	/* ***..... */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xFA */
	0x00,	/* ........ */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xFB */
	0x78,	/* .****... */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xFC */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xFD */
	0x00,	/* ........ */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0xf8,	/* *****... */

	/* 0xFE */
	0x00,	/* ........ */
	0xc0,	/* **...... */
	0xc0,	/* **...... */
	0xf8,	/* *****... */
	0xcc,	/* **..**.. */
	0xf8,	/* *****... */
	0xc0,	/* **...... */
	0xc0,	/* **...... */

	/* 0xFF */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0x00,	/* ........ */
	0xcc,	/* **..**.. */
	0xcc,	/* **..**.. */
	0x7c,	/* .*****.. */
	0x0c,	/* ....**.. */
	0xf8,	/* *****... */
};
